function desenha_funcao
close all
clc
%--- funcao a aproximar
%Se o parametro for 0 faz analise global
parametros.funcao = 16;
%--- dimensao do dominio
parametros.dim_dominio = 2;
%--- tamanho do dominio
%o dominio D eh a caixa [0,tam_dominio]^dim_dominio
%deve ser um inteiro positivo.
parametros.tam_dominio = [40 40];
%--- centros
%se {n_centros = 0} usa uma grade uniforme de centros com passo 1
%caso contrario, usa um  conjunto de
%n_centros centros nao uniforme {C(i)}.
parametros.n_centros = 0;
parametros.tam_grade_centros = parametros.tam_dominio;
%--- grade de integracao
%se {n_pontos = 0} usa uma grade uniforme de pontos 
%caso contrario, usa um  conjunto de
%n_pontos centros nao uniforme {p(i)}.
%ha aproximadamente pts_por_celula pontos de amostragem por celula
parametros.n_pontos = 0;
parametros.pts_por_celula = 9; 
%--- base de aproximacao
parametros.tipobase = NaN;%definido abaixo
parametros.raio = NaN;  %definido abaixo
parametros.raios = NaN; %definido abaixo
parametros.raio_otimo = 1.0;
parametros.le_matriz = true;
parametros.min_nivel = NaN;
parametros.max_nivel = NaN;
parametros.adap_por_nivel = NaN; %usa reducao de base na hier_adap
parametros.hier_adap_recalc = NaN; %recalcula alpha depois de reduzir a base
parametros.tipoarvore = NaN;  %1=diadica, 2=quadtree
parametros.tensorial = NaN; %definido abaixo

% --- metodo de aproximacao
parametros.metodo = 1; %1 MQ, 3 MQ ignorando outliers.
%--- criterio de aproximacao adaptativa
parametros.tol = NaN;
parametros.heu_adap = NaN;

%opcoes de plotagem
plota.funcao = true;
plota.arvore = false;
plota.base = true; %desenha os elementos da base
plota.curva_nivel = false; %desenha os elementos por curvas de niveis
plota.coeficientes = true;
plota.componentes = false;
plota.base_dual = true;
plota.aproximacao = true;
plota.erro = true;
plota.emax = 1.5*parametros.tol;
plota.mapa_erro = true;
plota.erro_curva_nivel = false;
plota.mapa_erro_curva_nivel = false;
plota.salva_eps = false;

%function desenha_funcao(parametros,plota)
%avalia aproximacao com base radial ou tensorial com centros em
%uma grade regular

%define grade de centros 
assert(parametros.dim_dominio == 2);
%assert(parametros.funcao > 0);
LD = parametros.tam_dominio;
CD = 0.5*LD; 
% LD = [1 1];
% CD = [0 0];%0.5*LD; 

%define os pontos de amostragem
NC = parametros.tam_grade_centros;
KP = calcula_pontos_por_celula(parametros.pts_por_celula,LD,NC);
NP = KP .* NC;
p = constroi_grade_de_amostras(CD,LD,NP);
np = size(p,1);
malha = constroi_malha_completa(CD,LD,NC,p);


%pasta principal para os plotes
sigla_metodo = ['MQ';'SS'; 'SO'; 'WQ'];
assert(parametros.tam_dominio(1) == parametros.tam_dominio(2));
pasta_raiz = cria_pasta(sprintf(...
    '~/Desktop/dout2012/Texto/Comum/E4-AD-F%02d',parametros.funcao));
dir1 = sprintf('tb%02d-ten%d-dob%d-gs%d',parametros.tipobase,...
    parametros.tensorial,1,...
    0);
dir2 = sprintf('TX%04d-TY%04d-NX%05d-NY%05d',NC(1),NC(2),NP(1),NP(2));
pasta_tipobase = cria_pasta(sprintf('%s/%s/%s',...
    pasta_raiz,dir1,dir2));
pasta_tipobase_metodo = cria_pasta(sprintf('%s/%s',...
    pasta_tipobase,sigla_metodo(parametros.metodo,:)));

%constroi as matriz f da funcao a aproximar
%f(i,j) valor da funcao numero j ( = 1) no ponto de amostragem i
f = discretiza_funcao(parametros,p,CD,LD);

nf = 1;
if plota.funcao
    figure(1);
    for j = 1:nf
        plota_funcao(p,f(:,j),true,CD,LD,NP,NaN,NaN);
        %define_zlim2(alpha,f,s);
        %title(sprintf('funcao %d',j),'FontSize',20);
        hold off
        if plota.salva_eps
            saveas(gcf,sprintf('%s/f%04d.eps',pasta_raiz,j));
        end
        %         pause(1)
    end
end
