function K = determina_celulas_criticas(malha,p,e,tol)
%recebe uma malha possivelmente incompleta, um vetor de pontos p, e um vetor
%de erros e, do mesmo tamanho que p.
%Devolve uma matriz K das posicoes das celulas da malha nas quais a norma
%Linf do residuo {e} eh maior que {tol}. 
%A norma Linf eh calculada sobre os pontos de amostragem 
%do vetor p que caem dentro da celula. Supoe que em cada celula da malha o 
%vetor {ixgpontos} dah os indices dos pontos de p (e portanto, do 
%residuo no vetor {e}) que caem dentro da malha.

np = size(p,1);
assert(size(p,2) == 2);
assert(size(e,2) == 1);
assert(size(e,1) == np);
nc = nnz(malha.ixc);
nk = 0;
K =[];
for i =1:nc
    celi = malha.celulas(i);
    posi = celi.pos;
    %verifica se essa celula eh critica
    e_max = 0;
    for k = celi.ixgpontos
        x = p(k,1);
        y = p(k,2);
        assert(ponto_na_celula(x,y,posi,malha))
        e_max = max([e_max,abs(e(k,1))]);
        %e(k,1)
        %e_max
    end
    if e_max > tol
        nk = nk + 1;
        K(nk,:) = posi;
    end
end
fprintf(2,'encontrou %d celulas criticas (tol = %8.6f) em %d \n',nk,tol,nc);