function K = determina_celulas_para_pontos(CD,LD,NC,p)
%determina a lista K das posicoes de um subconjunto das celulas da malha
%uniforme com NC(1) x NC(2) celulas no dominio CD, LD. A lista K conterah
%apenas as celulas que contem algum ponto da lista p. Os vetores ixgpontos
%dessas celulas conterao indices para o vetor p.

np = size(p,1);
assert(size(p,2) == 2)

%Constroe uma tabela ixc tal que ixc(ix+1,iy+1) eh o indice na lista K
%da celula com posicao [ix,iy], ou zero se tal celula nao estah lah.
ixc = sparse(NC(1),NC(2));

LD_c = LD ./ NC;  %tamanho da celula
MD = CD - 0.5*LD;  %canto inferior do dominio
nc = 0; %numero de celulas criadas
nk = 0;
K = zeros(0,2);
for i = 1:np
    %determina a posicao pos da celula que contem o ponto i.
    xi = p(i,1);
    yi = p(i,2);
    assert((xi >= MD(1)) && (xi < MD(1)+LD(1)))
    assert((yi >= MD(2)) && (yi < MD(2)+LD(2)))
    pos = floor(([xi, yi] - MD) ./ LD_c);
    assert(pos(1) >= 0)
    assert(pos(1) < NC(1))
    assert(pos(2) >= 0)
    assert(pos(2) < NC(2))
    
    %verifica se esta celula ja apareceu
    icel = ixc(pos(1)+1,pos(2)+1);
    if icel == 0
        nc = nc + 1;
        icel = nc;
        K(icel,:) = pos; 
        ixc(pos(1)+1,pos(2)+1) = icel;
    end
    %ponto estah na celula icel
    assert((icel >= 1) && (icel <= nc))
    
end


