function malha_rv = determina_elementos_construtiveis(malha_kv,kv,passov,...
    KF,tipobase,p,NP)
%supoe que a malha_kv contem todas as celulas centrais dos elementos de uma
%certa subbase base_kv de uma base uniforme de tipo tipobase do nivel kv. 
%Controi uma 
%malha malha_rv para o nivel rv = kv - passov com as celulas centrais de 
%todos os elementos desse nivel que podem se construidos por combinacao 
%linear de elementos da base base_kv. 
%Supoe que a base eh tensorial e dobrada

rv = kv - passov;
ng = num_de_elementos_geradores_do_prox_nivel(tipobase);
assert(mod(ng,2) == 0)
KG = KF + (KF - [1, 1])*(ng - 2);  
DG = (KF - [1, 1])*(ng - 2)/2;
NC_kv = malha_kv.NC;
NC_rv = NC_kv ./ KF;
malha_rv = constroi_malha_vazia(malha_kv.CD,malha_kv.LD,NC_rv);
for dx = 0:NC_rv(1) - 1
    for dy = 0:NC_rv(2) - 1
        cpos_rv = [dx,dy];
        construtivel = true; 
        for kx = 0:KG(1) - 1
            for ky = 0:KG(2) - 1
                cpos_kv = mod(cpos_rv .* KF + [kx, ky] - DG,NC_kv);
                icel_kv = encontra_celula_pela_posicao(cpos_kv,malha_kv);
                if icel_kv == 0
                    construtivel = false;
                end
            end
        end
        if construtivel
            malha_rv = acrescenta_celula_na_malha(malha_rv,cpos_rv,NP);
        end
    end
end
        
                