function [E,Q] = determina_elementos_relevantes(K,NC,LD,raio_abs,tipobase,...
    prebase_gorda)
%devolve um vetor E com as posicoes de todos os elementos de uma base
%uniforme que sao relevantes para o conjunto de celulas criticas K. Se 
%prebase_gorda eh true, inclui todos os elementos cujos suportes 
%interceptam as celulas cujas posicoes estao no 
%vetor K.  Se prebase_gorda eh false inclui apenas os elementos centrados 
%nessas celulas. Tambem devolve um vetor Q com as posicoes de todas as celulas que 
%interceptam os suportes desse elementos. Supoe uma malha
%uniforme com NC(1) x NC(2) celulas e uma base uniforme com centros nos
%centros das celulas, funcao-mae de tipo tipobase e raio 
%raio_abs(1) x raio_abs(2).

%determina o numero de celulas interceptadas por um elemento, em cada eixo
%supoe que o suporte intercepta um conjunto retangular de celulas
NS = celulas_no_suporte(NC,LD,raio_abs,tipobase); 
fprintf(2,'suporte do elemento intercepta %d x %d celulas\n',NS(1),NS(2));

if (NS(1) < NC(1)) 
    RS(1) = (NS(1) - 1)/2;
else
    RS(1) = floor(NC(1)/2);
end
if (NS(2) < NC(2)) 
    RS(2) = (NS(2) - 1)/2;
else
    RS(2) = floor(NC(2)/2);
end
fprintf(2,'alargando o conjunto com %d x %d celulas\n',RS(1),RS(2));
if prebase_gorda
    E = expande_conjunto_de_celulas(K,NC,RS);
else 
    E = K;
end
Q = expande_conjunto_de_celulas(E,NC,RS);
    
    
    