function U = determina_filhos_das_celulas(Q,NC_a,NC)
%dado uma matriz Q (nq x 2), com as posicoes de certas celulas do nivel 
%anterior, devolve um vetor U com as posicoes das celulas do nivel corrente 
%que sao filhas dessas celulas. 
%Supoe que o nivel anterior  tem NC_a(1) x NC_a(2) celulas e o nivel 
%corrente tem que tem NC(1) x NC(2) celulas.

nq = size(Q,1);

%determina quantos filhos cada celula tem
assert(max(mod(NC,NC_a)) == 0) 
nh = NC./NC_a;
assert(min(nh) >= 1 && max(nh) == 2)  
nu = 0;
for i = 1:nq
    d_a = Q(i); %posicao da celula mae na grade anterior
    assert((d_a(1,1) >= 0) && (d_a(1,1) < NC_a(1)))
    assert((d_a(1,2) >= 0) && (d_a(1,2) < NC_a(2)))
    
    %determina a posicao do primeiro filho de j na grade corrente
    d = d_a.*nh;
    
    %acrescenta as celulas que sao filhas da celula d_a
    for ty = 0:nh(1,2)-1
          for tx = 0:nh(1,1)-1
            %calcula a posicao d da celula filha na grade corrente
            d = d_a .* nh + [tx,ty];
            nu = nu + 1;
            U(nu,:) = d;
          end
    end
end


