function PR = determina_pontos_relevantes(malha)
%dada uma malha que usa um subconjunto da celulas de uma malha 
%regular, devolve um vetor PR que contem o indice em algum vetor p de 
%todos os pontos de amostragem que estao dentro de alguma celula da malha.
%Supoe que em cada celula da malha a lista {ixgpontos}
%contem os indices em algum vetor de pontos que estao dentro da celula

nc = nnz(malha.ixc);
np_v = 0;
for i = 1:nc
    celi = malha.celulas(i);
    npi = size(celi.ixgpontos,2);
    PR(1,np_v+1:np_v+npi) = celi.ixgpontos;
    np_v = np_v + npi;
end
