function [A,base] = discretiza_base(p,malha,base,tensorial,np_comp,PRbase)
%Supoe que p eh um vetor pontos de amostragem, um subconjunto da
%lista p_comp de pontos de amostragem completa que tem np_comp pontos.
%Supoe que em cada celula da malha o vetor ixgpontos
%contem os indices em p_comp dos pontos que estao dentro dessa celula.
%Supoe que PRbase(k) eh o indice em p_comp do ponto p(k).
%Constroi a matriz A da base dada para o subconjunto p de
%pontos. O indices das linhas de A sao indices nesse subconjunto.

fprintf(2,'-----------inicio discretiza_base-------------\n');
nb = size(base.elementos,2);
fprintf(2,'numero de elementos = %d\n', nb);
fprintf(2,'numero de pontos de amostragem completos = %d\n', np_comp);
np = size(PRbase,2);
fprintf(2,'numero de pontos de amostragem na base = %d \n', np);
nc = nnz(malha.ixc);
fprintf(2,'numero de celulas na malha = %d\n', nc);
NC = malha.NC;
RPbase = inverte_permutacao(PRbase,np_comp);
assert(max(RPbase) == np)

A = sparse(np,nb);
for j = 1:nb
    elemj = base.elementos(j);
    Cj = elemj.centro;
    Rj = elemj.raio_abs;
    tipobasej = elemj.tipobase;
    if mod(j,10) == 1
        fprintf(2,' %d',j);
    end
    posj = elemj.pos; %posicao do elemento j na grade completa
    NS = celulas_no_suporte(malha.NC,malha.LD,Rj,tipobasej);
    d_min = primeira_celula_do_suporte(NS,malha.NC);
    d_max = ultima_celula_do_suporte(NS,malha.NC);
    for dx = d_min(1)-1:d_max(1)+1
        xfora = ((dx < d_min(1)) || (dx > d_max(1))) && (NS(1) < NC(1));
        for dy = d_min(2)-1:d_max(2)+1
            yfora = ((dy < d_min(2)) || (dy > d_max(2))) && (NS(1) < NC(1));
            posd = reduz_posicao(posj + [dx, dy],malha.NC);
            iceld = encontra_celula_pela_posicao(posd,malha);
            if iceld > 0
                celd = malha.celulas(iceld);
                for i_comp = celd.ixgpontos
                    %encontra o indice do ponto no vetor p
                    i = RPbase(i_comp);
                    if (i < 1) || (i > np)
                        assert(xfora || yfora, 'ponto no suporte nao selecionado')
                    else
                        z = [p(i,1) p(i,2)];
                        Aij = phi(z,tipobasej,tensorial,Cj,Rj,malha.LD);
                        if (xfora || yfora)
                            assert(Aij == 0, 'elemento nao nulo fora do suporte')
                        else
                            A(i,j) = Aij;
                        end
                    end
                end
            else
                assert(xfora || yfora, 'falta celula do suporte')
            end
        end
    end
end
fprintf(2,'\n');
fprintf(2,'-----------fim discretiza_base-------------\n');