function A0 = discretiza_coluna_padrao_da_matriz_A(p,...
    centro,raio_abs,tipobase,tensorial,LD)
%calcula o valor do elemento correspondente a celula de posicao
%zero da malha para todos os pontos de amostragem em p. Devolve o
%resultado com um vetor coluna. Supoe que o dominio tem tamanho LD.

np = size(p,1);
A0 = sparse(np,1);
for i = 1:np
    %!!! deveria calcular apenas os pontos no suporte do elemento zero 
    z = [p(i,1) p(i,2)];
    A0i = phi(z,tipobase,tensorial,centro,raio_abs,LD);  
    if A0i ~= 0
        A0(i,1) = A0i;
    end
end


