function A0 = discretiza_em_grade_regular_coluna_padrao_da_matriz_A(NC,...
    NP,p,centro,raio_abs,tipobase,tensorial,LD)

%calcula o valor do elemento correspondente a celula de posicao
%zero de uma malha com NC(1) x NC(2) celulas, para todos os pontos de
%amostragem em p, que deve ser uma grade completa de amonstragem com
%NP(1) x NP(2). Devolve o
%resultado com um vetor coluna. Supoe que o dominio tem tamanho LD.
  
np = size(p,1);
assert(np == prod(NP))
KP = NP ./ NC;
fprintf(2,'discretizando A0 pontos = %d %d celulas = %d %d ppc = %d %d\n',...
    NP,NC,KP);
A0 = sparse(np,1);
NS = celulas_no_suporte(NC,LD,raio_abs,tipobase);
fprintf(2,'suporte do elemento = %d x %d celulas\n',NS(1),NS(2));
d_min = primeira_celula_do_suporte(NS,NC);
d_max = ultima_celula_do_suporte(NS,NC);
ns = 0;
for dsx = d_min(1):d_max(1)
    for dsy = d_min(2):d_max(2)
        posc = mod([dsx, dsy],NC);
        %enumera os pontos da grade completa dentro dessa celula
        pposc = posc .* KP; %posicao do primeiro ponto da celula posc
        for dx = 0:KP(1)-1
            for dy = 0:KP(2)-1
                pposi = pposc + [dx, dy];
                i = 1 + pposi(1)*NP(2) + pposi(2); %indice do ponto na grade completa
                assert((i >= 1) && (i <= np))
                z = p(i,:);
                A0i = phi(z,tipobase,tensorial,centro,raio_abs,LD);
                if A0i ~= 0
                    A0(i,1) = A0i;
                    ns = ns + 1;
                    if (mod(ns,100)) == 1
                        fprintf(2,' %d',ns);
                    end
                end
            end
        end
    end
end
fprintf(2,'\n');

