function [malha_h,base_h,A_h,inib_h,tamb_h] = ...
    elimina_redundantes_hier2(parametros,malha_h,base_h,iv,...
    NC_iv,CD,LD,NP,A_h,inib_h,tamb_h,p,plota,pasta,estagio)
%supoe que base_h eh uma base multinivel com niveis desde 
%parametros.min_nivel ateh iv
%inclusive. Elimina da base todos os elementos que podem ser escritos como 
%combinacao de elementos dos niveis inferiores.

fprintf(2,'--- inicio de elimina redundantes ------------\n');
passov = passo_nivel(parametros);
min_nivel = parametros.min_nivel;
verifica_base_hier2(base_h,A_h,min_nivel,passov,iv,inib_h,tamb_h,p);
KF_iv = numero_de_filhos(parametros.tipoarvore,parametros.dim_dominio,iv);
NC_g = NC_iv .* KF_iv;
malha_g  = constroi_malha_vazia(CD,LD,NC_g);


for kv = iv:-passov:min_nivel
    fprintf(2,'eliminando redundantes do nivel %d\n',kv);
    %Neste ponto malha_g eh uma malha do nivel kv + passov que contem a
    %as celulas centrais de todos os elementos desse nivel que estao 
    %presentes na base, diretamente ou indiretamente por composicao de
    %elementos de niveis mais refinados. 
    assert(malha_g.NC(1) == NC_g(1))
    assert(malha_g.NC(2) == NC_g(2))
    ng = nnz(malha_g.ixc);
    fprintf(2,'elementos existentes no nivel %d = %d\n',kv+passov,ng);
    %elimina todos os elementos de malha_h(kv) que  sao gerados por
    %combinacao dos niveis mais refinados.
    KF_kv = numero_de_filhos(parametros.tipoarvore,parametros.dim_dominio,kv);
    
    NC_kv = NC_g ./ KF_kv;
    malha_b(kv) = determina_elementos_construtiveis(malha_g,kv+passov,passov,...
        KF_kv,parametros.tipobase,p,NP);
    assert(malha_b(kv).NC(1) == NC_kv(1))
    assert(malha_b(kv).NC(2) == NC_kv(2))
    nb = nnz(malha_b(kv).ixc);
    fprintf(2,'elementos construtiveis no nivel %d = %d\n',kv,nb);
    j1 = inib_h(kv);
    j2 = j1 + tamb_h(kv) - 1;
    %percorre elementos ao contrario par'a que a eliminacao nao atrapalhe a
    %contagem
    for j = j2:-1:j1
        elemj = base_h.elementos(j);
        posj = elemj.pos;
        fprintf(2,'verificando elemento %d = [%d %d] do nivel %d ... ', ...
            j,posj(1),posj(2),kv);
        icelj = encontra_celula_pela_posicao(posj,malha_b(kv));
        
        if icelj ~= 0
            fprintf(2,'eliminado\n');
            [base_h,A_h,inib_h,tamb_h] = elimina_elemento_hier2(base_h,...
                A_h,inib_h,tamb_h,kv,passov,iv,j);
        else 
            fprintf(2,'mantido\n');
        end
        malha_b(kv) = acrescenta_celula_na_malha(malha_b(kv),posj,NP);
    end
    malha_g = malha_b(kv);
    NC_g = NC_kv;
end
figure(229); clf;
plota_malhas_hier2(malha_b,...
    min_nivel,passov,iv-passov,pasta,plota,estagio,'b')

verifica_base_hier2(base_h,A_h,min_nivel,passov,iv,...
    inib_h,tamb_h,p)
fprintf(2,'--- fim de elimina redundantes ------------\n');

