function ix_a = escolhe_sub_base_ApAd2(A,alpha,e,tol)
%devolve a lista ix_a dos indices dos elementos da subbase escolhida
%a lista pode ser vazia e nao contem os elementos cujos alphas sao zeros
nb = size(A,2);
fprintf(2,'calculo dos deltas\n');
for j = 1:nb
    aaj = abs(alpha(j));
    nAj = norma_erro_Linf(A(:,j));
    delta(j) = full(aaj*nAj);
end

fprintf(2,'ordenando os deltas\n');
[delta_s,ix] = sort(delta);
nb_a = 0; %numero de elementos nao eliminados
ix_a = zeros(1,nb);
e_a = e; %o residuo com a subbase corrente
erro_a = norma_erro_Linf(e_a);
fprintf(2,'erro inicial = %9.6f\n',erro_a);
for k = 1:nb
    j = ix(k);
    fprintf(2,'considerando elemento %d delta = %9.6f',j,delta(j));
    if pode_retirar_elemento(A(:,j),alpha(j),e_a,tol)
        %podemos eliminar o elemento j
        I = find(A(:,j));
        erro_ant = norm(e_a(I),inf);
        e_a = e_a + alpha(j)*A(:,j);
        %recalcula erro_a = norma_erro_Linf(e_a) de maneira esparsa
        erro_pos = norm(e_a(I),inf);
        fprintf(2,'erro_ant = %9.6f erro_pos = %9.6f',erro_ant, erro_pos);
        if erro_pos >= erro_a
            erro_a = erro_pos;
            fprintf(2,'erro_a = %9.6f',erro_a);
        elseif erro_pos >= erro_ant
            %erro_a nao mudou
        elseif erro_ant < erro_a
            %erro_a nao mudou
        else 
            %precisa recalcular o erro em todo o dominio
            assert(erro_ant == erro_a)
            erro_a = norma_erro_Linf(e_a);
            fprintf(2,'erro_a = %9.6f',erro_a);
        end
        alpha(j) = 0;
        fprintf(2,' eliminado\n'); 
    elseif delta(j) > 2*tol
        %nao adianta olhar os elementos que restam
        fprintf(2,' terminado\n');
        nr = nb - k + 1;
        ix_a(nb_a+1:nb_a+nr) = ix(k:nb);
        nb_a = nb_a + nr;
        break
    else
        %temos que manter o elemento j
        fprintf(2,' mantido\n'); 
        nb_a = nb_a + 1;
        ix_a(nb_a) = j;
    end        
end
assert((nb_a >= 0) && (nb_a <= nb))
fprintf(2,'eliminados %d elementos, mantidos %d \n',nb-nb_a,nb_a);
fprintf(2,'erro final = %9.6f\n',erro_a);
if nb_a == 0
    ix_a = [];
else
    ix_a = ix_a(1:nb_a);
    ix_a = sort(ix_a);
end