function ix_a = escolhe_sub_base_ApAd3(A,alpha,e,tol)
%devolve a lista ix_a dos indices dos elementos da subbase escolhida
%a lista pode ser vazia e nao contem os elementos cujos alphas sao zeros
%assert(false)
%vamos consertar depois
nb = size(A,2);
nb_a = nb; %numero de elementos que ainda nao foram examinados
ix_a = 1:nb; %indices dos elementos que ainda nao foram examinados
e_a = e; %o residuo com a subbase corrente
erro_a = norma_erro_Linf(e_a);
fprintf(2,'%d erro inicial = %9.6f\n',erro_a);
while nb_a >0
    %calcula os epsilons e determina o indice r do menor que nao eh critico
    fprintf(2,'calculo dos epsilons\n');
    r = 0;
    kr = 0;
    for k = 1:nb_a
        j = ix_a(k);
        Aj = A(:,j);
        if ~elemento_eh_critico(Aj,alpha,e_a,tol)
            if alpha(j) == 0
                r = j;
                kr = k;
                eps(j) = erro_a;
            else
                eps(j) = norma_erro_Linf(e_a + alpha(j)*A(:,j));
                if (r == 0) || (eps(j) < eps(r))
                    r = j;
                    kr = k;
                end
            end
        else
            eps(j) = Inf;
        end
    end
    %r = ix_a(kr) eh o indice do melhor elemento a eliminar, ou 0 se nao tem
    if (r == 0) || (eps(r) > tol)
        %nao da para eliminar nenhum elemento
        fprintf(2,' terminado\n');
        break
    end
    fprintf(2,'considerando elemento %d eps = %9.6f',r,eps(r));
    fprintf(2,' eliminado\n');
    ix_a(kr) = ix_a(nb_a);
    nb_a = nb_a - 1;
    alpha(r) = 0;
    e_a = e_a + alpha(r)*A(:,r);
    erro_a = eps(r);
end
assert((nb_a >= 0) && (nb_a <= nb))
fprintf(2,'eliminados %d elementos, mantidos %d \n',nb-nb_a,nb_a);
fprintf(2,'erro final = %9.6f\n',erro_a);
if nb_a == 0
    ix_a = [];
else
    ix_a = ix_a(1:nb_a);
    ix_a = sort(ix_a);
end