function E = expande_conjunto_de_celulas(K,NC,RS)
%dado um conjunto K de posicoes de celulas, devolve outro conjunto E com as
%posicoes de todas as celulas que estao deslocadas no maximo RS celulas da 
%celulas de K. Supoe uma grade regular com NC(1) x NC(2) celulas.

RX = RS(1,1);
RY = RS(1,2);

ne_bruto = 0; %numero de elementos relevantes encontrados com repeticoes
nk = size(K,1); % numero de celulas criticas
E = zeros(0,2);
for i=1:nk
    pos_K = K(i,:); %posicao de uma celula critica
    assert(pos_K(1,1) == floor(pos_K(1,1)))
    assert(pos_K(1,2) == floor(pos_K(1,2)))
    for dy = (-RY):RY
        for dx = (-RX):RX
            pos_E = reduz_posicao(pos_K + [dx, dy],NC);
            ne_bruto = ne_bruto + 1;
            E(ne_bruto,:) = pos_E;
        end
    end
end
E = posicoes_unicas(E);