function figuras_adaptativa
close all
fclose('all');
clc
%--- funcao a aproximar
%Se o parametro for 0 faz analise global
parametros.funcao = NaN;
%--- dimensao do dominio
parametros.dim_dominio = 2;
%--- tamanho do dominio
%o dominio D eh a caixa [0,tam_dominio]^dim_dominio
%deve ser um inteiro positivo.
parametros.tam_dominio = [50 50];
%--- centros
%se {n_centros = 0} usa uma grade uniforme de centros com passo 1
%caso contrario, usa um  conjunto de
%n_centros centros nao uniforme {C(i)}.
parametros.n_centros = 0;
parametros.tam_grade_centros = parametros.tam_dominio;
%--- grade de integracao
%se {n_pontos = 0} usa uma grade uniforme de pontos
%caso contrario, usa um  conjunto de
%n_pontos centros nao uniforme {p(i)}.
%ha aproximadamente pts_por_celula pontos de amostragem por celula
parametros.n_pontos = 0;
parametros.pts_por_celula = 9;
%--- base de aproximacao
parametros.tipobase = NaN;%definido abaixo
parametros.raio = NaN;  %definido abaixo
parametros.raios = NaN; %definido abaixo
parametros.raio_otimo = 1.0;
parametros.le_matriz = true;
parametros.min_nivel = NaN;
parametros.max_nivel = NaN;
parametros.prebase_gorda = NaN;
parametros.adap_por_nivel = NaN; %usa reducao de base na hier_adap
parametros.hier_adap_recalc = NaN; %recalcula alpha depois de reduzir a base
parametros.tipoarvore = NaN;  %1=diadica, 2=quadtree
parametros.tensorial = NaN; %definido abaixo

% --- metodo de aproximacao
parametros.metodo = 1; %1 MQ, 3 MQ com supressao de outliers.
%--- criterio de aproximacao adaptativa
parametros.tol = 0.0025;
parametros.heu_adap = 2;

%opcoes de plotagem
plota.funcao = true;
plota.pontos = NaN;
plota.arvore = false;
plota.base = true; %desenha os elementos da base
plota.curva_nivel = false; %desenha os elementos por curvas de niveis
plota.coeficientes = false;
plota.componentes = false;
plota.base_dual = true;
plota.aproximacao = true;
plota.erro = true;
plota.emax = 1.5*parametros.tol;
plota.mapa_erro = false;
plota.erro_curva_nivel = false;
plota.mapa_erro_curva_nivel = false;
plota.salva_eps = true;

funcoes = 16;%[1 2 16 8];
for func = funcoes
    parametros.funcao = func;
    fprintf('==== funcao %d ====================\n',parametros.funcao);
    
    fprintf('--- wendland 3,2 tensorial ------------\n');
    parametros.tipobase = 2;
    parametros.tensorial = true;
    parametros.raio = 3.5;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota);
    
    fprintf('--- Wendland 5,4 tensorial ------------\n');
    parametros.tipobase = 8;
    parametros.tensorial = true;
    parametros.raio = 4.5;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota);
    
%     fprintf('--- B-spline de grau 0 tensorial ------------\n');
%     parametros.tipobase = 4;
%     parametros.tensorial = true;
%     parametros.raio = 1;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota);
%     
%     fprintf('--- B-spline de grau 1 tensorial ------------\n');
%     parametros.tipobase = 5;
%     parametros.tensorial = true;
%     parametros.raio = 1;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota);
    
    fprintf('--- B-spline de grau 2 tensorial ------------\n');
    parametros.tipobase = 6;
    parametros.tensorial = true;
    parametros.raio = 1;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota);
    
    fprintf('--- B-spline de grau 3 tensorial ------------\n');
    parametros.tipobase = 12;
    parametros.tensorial = true;
    parametros.raio = 1;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota);
    %
    fprintf('--- B-spline de grau 4 tensorial ------------\n');
    parametros.tipobase = 14;
    parametros.tensorial = true;
    parametros.raio = 1;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota)
    
    fprintf('--- B-spline de grau 5 tensorial ------------\n');
    parametros.tipobase = 15;
    parametros.tensorial = true;
    parametros.raio = 1;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota)
    
    
    
    fprintf('--- gaussiana -----------------------------------\n');
    parametros.tipobase = 9;
    parametros.tensorial = true;
    parametros.raio = 1.10;
    parametros.raios = parametros.raio;
    principal_avalia_adaptativa(parametros,plota)
    
end





%---------------Trabalho anterior----------------------------------------
%     fprintf('--- Mexicana -----------------------------------\n');
%     parametros.tipobase = 13;
%     parametros.tensorial = true;
%     parametros.raio = 1.36;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota)

%     fprintf('--- Multiquadrica inversa radial --------------\n');
%     parametros.tipobase = 3;
%     parametros.tensorial = false;
%     parametros.raio = 2.5;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota)
%
%     fprintf('--- Multiquadrica inversa tensorial ------------\n');
%     parametros.tipobase = 3;
%     parametros.tensorial = true;
%     parametros.raio = 2.0;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota)
%     fprintf('--- Wendland 3,2 radial ------------\n');
%     parametros.tipobase = 2;
%     parametros.tensorial = false;
%     parametros.raio = 3.25;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota)
%

%     fprintf('--- Wendland 5,4 radial ------------\n');
%     parametros.tipobase = 8;
%     parametros.tensorial = false;
%     parametros.raio = 4.5;
%     parametros.raios = parametros.raio;
%     principal_avalia_adaptativa(parametros,plota)
%