function figuras_hier_adap
close all
fclose('all');
clc
%--- funcao a aproximar
%Se o parametro for 0 faz analise global
parametros.funcao = NaN;
%--- dimensao do dominio
parametros.dim_dominio = 2;
%--- tamanho do dominio 
%o dominio D eh a caixa [0,tam_dominio]^dim_dominio
%nao precisa ser um inteiro.
parametros.tam_dominio = [8 8];
%--- centros 
%
%
%
parametros.n_centros = NaN; %irrelevante
parametros.tam_grade_centros = [NaN NaN]; %definido internamente
%--- grade de integracao
%se {n_pontos = 0} usa uma grade uniforme de pontos
%caso contrario, usa um  conjunto de
%n_pontos centros nao uniforme {p(i)}.
%ha aproximadamente pts_por_celula pontos de amostragem por celula
parametros.n_pontos = 0;
parametros.pts_por_celula = 1;
%--- base de aproximacao
parametros.tipobase = NaN;%definido abaixo
parametros.raio = NaN;  %definido abaixo
parametros.raios = NaN; %nao usado
parametros.raio_otimo = NaN; %nao usado
parametros.le_matriz = true;
parametros.min_nivel = 7;
parametros.max_nivel = 17;
parametros.prebase_gorda = false; %inclue todo elem que cobre celula critica
parametros.adap_por_nivel = true; %usa reducao de base na hier_adap
parametros.hier_adap_recalc = false; %recalcula alpha depois de reduzir a base
parametros.tipoarvore = 2;  %1=diadica, 2=quadtree
parametros.tensorial = NaN; %definido abaixo

%ajusta tamanho do dominio conforme o tipo de arvore
if parametros.tipoarvore == 1
    fator = [2^0.25, 2^(-0.25)];
    parametros.tam_dominio = parametros.tam_dominio .* fator;
end

% --- metodo de aproximacao
parametros.metodo = 3; %1 MQ, 3 MQ com supressao de outliers.
%--- criterio de aproximacao adaptativa
parametros.tol = 0.002;
parametros.heu_adap = 2;

%opcoes de plotagem
plota.funcao = true;
plota.pontos = NaN;
plota.arvore = false;
plota.base = false; %desenha os elementos da base
plota.curva_nivel = false; %desenha os elementos por curvas de niveis
plota.coeficientes = false;
plota.componentes = false;
plota.base_dual = false;
plota.aproximacao = true;
plota.erro = true;
plota.emax = 1.5*parametros.tol;
plota.mapa_erro = false;
plota.erro_curva_nivel = false;
plota.mapa_erro_curva_nivel = false;
plota.salva_eps = true;

funcoes = [1 2 16 8 17]; 
for func = funcoes
    parametros.funcao = func;
    fprintf('==== funcao %d ====================\n',parametros.funcao);
    
%     fprintf('--- Gaussina -----------------------------------\n');
%     parametros.tipobase = 9;
%     parametros.tensorial = true;
%     parametros.raio = 1.2;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
%     
%     fprintf('--- Mexicana -----------------------------------\n');
%     parametros.tipobase = 13;
%     parametros.tensorial = true;
%     parametros.raio = 1.36;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
    
%     
%     fprintf('--- Multiquadrica inversa radial --------------\n');
%     parametros.tipobase = 3;
%     parametros.tensorial = false;
%     parametros.raio = 2.5;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
    
%     fprintf('--- Multiquadrica inversa tensorial ------------\n');
%     parametros.tipobase = 3;
%     parametros.tensorial = true;
%     parametros.raio = 2.0;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
%     
%     fprintf('--- Wendland 3,2 radial ------------\n');
%     parametros.tipobase = 2;
%     parametros.tensorial = false;
%     parametros.raio = 3.25;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
%     
%     fprintf('--- Wendland 3,2 tensorial ------------\n');
%     parametros.tipobase = 2;
%     parametros.tensorial = true;
%     parametros.raio = 3.5;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
%     
%     fprintf('--- Wendland 5,4 radial ------------\n');
%     parametros.tipobase = 8;
%     parametros.tensorial = false;
%     parametros.raio = 4.5;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
%     
%     fprintf('--- Wendland 5,4 tensorial ------------\n');
%     parametros.tipobase = 8;
%     parametros.tensorial = true;
%     parametros.raio = 4.5;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
%     
%     fprintf('--- B-spline de grau 1 tensorial ------------\n');
%     parametros.tipobase = 5;
%     parametros.tensorial = true;
%     parametros.raio = 1;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota)
    
    fprintf('--- B-spline de grau 2 tensorial ------------\n');
    parametros.tipobase = 6;
    parametros.tensorial = true;
    parametros.raio = 1;
    parametros.raios = parametros.raio;
    principal_avalia_hier_adap(parametros,plota)
    
%     fprintf('--- B-spline de grau 3 tensorial ------------\n');
%     parametros.tipobase = 12;
%     parametros.tensorial = true;
%     parametros.raio = 1;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota) 
    
%     fprintf('--- B-spline de grau 4 tensorial ------------\n');
%     parametros.tipobase = 14;
%     parametros.tensorial = true;
%     parametros.raio = 1;
%     parametros.raios = parametros.raio;
%     principal_avalia_hier_adap(parametros,plota) 

end
