function v = funcao_cratera(x,y)
S = 0.92;  %fator de escala geral 
R0 = 0.35*S;
h = 0.11*S;
R1 = 0.13*S;
FX = 0.3*pi/R1;
FY = 0.4*pi/R1;

r2 = x^2 + y^2;
R12 = R1*R1;
R22 = (R0 - h)^2;
R32 = (R0 + h)^2;
%pico central
%v1 = exp(-5*r2/(R1*R1))*cos(FX*x + FY*y
if r2 >= R12
    v1 = 0;
else
    u = r2/R12;
    v1 = (1 - u)^2; 
end
%parede circular 
if (r2 >= R32) || (r2 <= R22)
    v0 = 0;
else
    z = (r2 - R22)/(R32-R22);
    v0 = (4*z*(1 - z))^2;
end
v = 0.5*v0 + v1;