function f = funcao_geral(funcao,x_abs,y_abs,CD,LD)
%reduz o dominio para [-1/2, 1/2]^2
%calcula a largura nominal rD do dominio
%garante que o quadrado mapeado para [-1/2, 1/2]^2 ocupa a mesma fracao do
%dominio nos dois tipos de arvores.
rD = sqrt(sqrt(0.5))*sqrt(prod(LD));
x = (x_abs - CD(1))/rD;
y = (y_abs - CD(2))/rD;
if funcao == 1
    f = funcao_franke(x,y);
elseif funcao == 2
    f = funcao_ondinhas(x,y);
elseif funcao == 6
    f = funcao_constante(x,y);
elseif funcao == 7
    f = funcao_calombo(x,y);
elseif funcao == 8
    f = funcao_cratera(x,y);
else
    %estas funcoes precisam que x e y variem de -0.5 a 0.5 no dominio inteiro
    x = (x_abs - CD(1))/LD(1);
    y = (y_abs - CD(2))/LD(2);
    if funcao == 3
        f = funcao_linear(x,y);
    elseif funcao == 4
        f = funcao_quadratica(x,y);
    elseif funcao == 5
        f = funcao_ondona(x,y);
    elseif funcao == 9
        f = funcao_hartley(x,y,1,0);
    elseif funcao == 10
        f = funcao_hartley(x,y,1,1);
    elseif funcao == 11
        f = funcao_hartley(x,y,55,89);
    elseif funcao == 12
        if x < 0
            f = 0;
        else
            f = funcao_hartley(x,y,55,89);
        end
    elseif funcao == 13
        if hypot(x,y) > 0.3
            f = 0;
        else
            f = funcao_hartley(x,y,55,89);
        end
    elseif funcao == 14
        f = funcao_espiral(x,y);
    elseif funcao == 15
        f = funcao_doispicos(x,y);
    elseif funcao == 16
        f = funcao_galaxia(x,y);
    elseif funcao == 17
        f = funcao_calombos(x,y);
    elseif funcao == 18
        f = funcao_spline5(x,y);      
    else
        assert(false,'funcao desconhecida')
    end
end