function v = funcao_mae(z,tipok)

if tipok == 0 %phi Multiquadrica nu = 1
    v = funcao_mae_mq(z,1);
elseif tipok == 1 %Spline thin-plate com nu = 1
    v = funcao_mae_sp(z,1);
elseif tipok == 10 %Spline thin-plate com nu = 2
    v = funcao_mae_sp(z,2);
elseif tipok == 11 %Spline thin-plate com nu = 3
    v = funcao_mae_sp(z,3);
elseif tipok == 2 %Pulso compacto
    v = funcao_mae_cm(z);
elseif tipok == 3 %Multiquadrica com nu = -1
    v = funcao_mae_mq(z,-1);
elseif tipok == 4 %pulso (b-spline) retangular
    if abs(z) < 0.5
        v = 1;
    elseif abs(z) > 0.5
        v = 0;
    else
        v = 0.5;
    end
elseif tipok == 5 %pulso B-spline triangular
    if abs(z) < 1
        v = 1 - abs(z);
    else
        v = 0;
    end
elseif tipok == 6 %pulso B-spline quadratico
    if abs(z) < .5
        v = 1-(4/3)*z^2;
    elseif abs(z) < 1.5
        v = (2/3)*(1.5 - abs(z))^2;
    else
        v = 0;
    end
elseif tipok == 12 %pulso B-spline cubico
    z = abs(z);
    if z < 1
        v = 1 - z^2*(6 - 3*z)/4;
    elseif z < 2
        v = (2 - z)^3/4;
    else
        v = 0;
    end
elseif tipok == 7 %Pulso compacto
    v = funcao_mae_cm14(z);
elseif tipok == 8 %Pulso compacto
    v = funcao_mae_cm54(z);
elseif tipok == 9
    %gaussiana
    if abs(z) < 8.5
        v = exp(-.5*z^2);
    else
        v = 0;
    end
elseif tipok == 13
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,2);
elseif tipok == 31
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,10);
elseif tipok == 32
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,5);
elseif tipok == 33
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,0.5);
elseif tipok == 34
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,1);
elseif tipok == 35
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,2.5);
elseif tipok == 36
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,3);
elseif tipok == 37
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,3.5);
elseif tipok == 38
    %gaussiana x sinc
    v = funcao_mae_mexicana(z,4);
elseif tipok == 14 %pulso B-spline de grau 4
    z = abs(z);
    if z <= .5
        v = 1 - (120/115)*z^2 + (48/115)*z^4;
    elseif (z <= 3/2) && (z > .5)
        v = 22/23 + (8/23)*z - (240/115)*z^2 + ...
            (160/115)*z^3 - (32/115)*z^4;
    elseif (z > 3/2) && (z <= 5/2)
        v = (16/230)*(5/2-z)^4;
    else
        v = 0;
    end
elseif tipok == 15 %pulso B-spline de grau 5
    z = abs(z);
    if z <= 1
        v = 1 + z^2*(-30 + z^2*(+15 + z*(-5)))/33;
    elseif (z > 1) && (z < 2)
        v = (+51 + z*(+75 + z*(-210 + z*(+150 + z*(-45 + z*(+5))))))/66;
    elseif (z >= 2) && (z <= 3)
        v = (3-z)^5/66;
    else
        v = 0;
    end
%     if z <= 1
%         v = 1 - (10/11)*z^2 + (5/11)*z^4 - ...
%             (5/33)*z^5;
%     elseif (z > 1) && (z < 2)
%         v = 17/22 + (25/22)*z - (35/11)*z^2 + (25/11)*z^3 - ...
%             (15/22)*z^4 + (5/66)*z^5;
%     elseif (z >= 2) && (z <= 3)
%         v = (1/66)*(3-z)^5;
%     else
%         v = 0;
%     end
elseif tipok == 40 %funcao gabor
    v = funcao_mae_gabor(z,0.5);
elseif tipok == 41 %funcao gabor
    v = funcao_mae_gabor(z,0.75);
elseif tipok == 42 %funcao gabor
    v = funcao_mae_gabor(z,1.0);
elseif tipok == 43 %funcao gabor
    v = funcao_mae_gabor(z,1.25);
elseif tipok == 44 %funcao gabor
    v = funcao_mae_gabor(z,1.5);
elseif tipok == 45 %funcao gabor
    v = funcao_mae_gabor(z,2.0);
elseif tipok == 46 %funcao gabor
    v = funcao_mae_gabor(z,3);
elseif tipok == 47 %funcao gabor
    v = funcao_mae_gabor(z,5.0);
elseif tipok == 52
    %Lanczos de ordem a = 2
    v = funcao_mae_lanczos(z,2);
elseif tipok == 53
    %Lanczos de ordem a = 3
    v = funcao_mae_lanczos(z,3);
elseif tipok == 60
    %chapeu mexicano
    v = funcao_mae_ricker(z);
else
    assert(false, 'tipok = %d invalido', tipok);
end


%casas decimais
% elseif tipok == 15 %pulso B-spline de grau 5
%     z = abs(z);
%     if z <= 1
%         v = 1 - 0.285899935022742*z^3 - 0.198180636777128*z^4 + ...
%             0.055230669265757*z^5;
%     elseif (z >= 1) && (z < 2)
%         v = 3.813840155945413 - 5.784600389863537*z + ...
%             3.284600389863542*z^2 - 0.808966861598439*z^3 + ...
%             0.063352826510721*z^4 + 0.002923976608187*z^5;
%     elseif (z >= 2) && (z <= 3)
%         v = 0.018518518518518*(3-z)^5;
%     else
%         v = 0;
%     end




% 
% DO LIVRO
% elseif tipok == 14
%     if (z >= -5/2) && (z < -3/2)
%         v = (1/24)*(z + 5/2)^4;
%     elseif (z >= -3/2) && (z <= -1/2)
%         v = (1/24)*(1 +4*(z+3/2) + 4*(z+3/2)^3 + 6*(z+3/2)^2 - ...
%             (z+3/2)^4);
%     elseif (z > -1/2) && (z < 1/2)
%         v = 1 - 2.83333333*z^2 + 4.66666667*z^4;
%     elseif (z >= 1/2) && (z < 3/2)
%         v = (1/24)*(1 + 4*(3/2-z) + 4*(3/2-z)^3 + 6*(3/2-z)^2 - ...
%             (3/2-z)^4);
%     elseif (z >= 3/2) && (z < 5/2)
%         v = (1/24)*((5/2-z)^4);
%     else
%         v = 0;
%     end

%--------------------------------------------

% elseif tipok == 15 %pulso B-spline de grau 5
%     z = abs(z);
%     if z <= 1
%         v = 1 - 1.125827814569536*z^3 + 0.364238410596026*z^4 - ...
%             0.114790286975717*z^5;
%     elseif (z >= 1) && (z < 2)
%         v = -0.354304635761586 + 2.003311258278143*z - ...
%             2.748344370860925*z^2 + 1.622516556291389*z^3 - ...
%             0.447019867549668*z^4 + 0.047461368653422*z^5;
%     elseif (z >= 2) && (z <= 3)
%         v = 0.005518763796909*(3-z)^5;
%     else
%         v = 0;
%     end
