function k = indice_de_centro_transladado(i,j,NC)
%supoe uma grade regular completa com NC(1)x NC(2) elementos identicos 
%devolve o indice k tal que phi_j(C_i) == phi_1(C_k)
%assert(parametros.dim_dominio == 2)
%assert(parametros.n_centros == 0);
nx = NC(1); %assert(floor(nx) == nx);
ny = NC(2); %assert(floor(ny) == ny);
%calcula indices do elemento i na grade (de 0 0 ateh [nx-1 ny-1]
iy = mod(i-1,ny);
ix = floor((i-1 - iy)/ny);
%assert((0 <= ix) && (ix < nx))
%assert((0 <= iy) && (iy < ny))

%calcula indices do elemento j na grade (de 0 0 ateh [nx-1 ny-1]
jy = mod(j-1,ny);
jx = floor((j-1 - jy)/ny);
%assert((0 <= jx) && (jx < nx))
%assert((0 <= jy) && (jy < ny))


kx = mod(ix - jx + nx,nx);
ky = mod(iy - jy + ny,ny);
%assert((0 <= kx) && (kx < nx))
%assert((0 <= ky) && (ky < ny))

k = 1 + kx*ny + ky;
%assert((1 <= k ) && (k <= nx*ny))