function ipontos = indices_de_pontos_da_celula(pos,NP,KP)
%devolve os indices de pontos de amostragem que estao dentro da celula de
%posicao pos. Supoe uma grade regular de NP(1) x NP(2) pontos de amostragem,
%numerados por coluna como KP(1) X KP(2) pontos por celula.
ini = 1 + pos(1)*KP(1)*NP(2) + pos(2)*KP(2);
mp = 0;
for dx = 0:KP(1)-1
    for dy = 0:KP(2)-1
        mp = mp + 1;
        ipontos(mp) = ini + dx*NP(2) + dy;
    end
end
assert(mp == KP(1)*KP(2))

        