function ixgpontos = indices_dos_pontos_na_celula(NC,NP,cpos)
%devolve um vetor com os indices dos pontos da grade de amostragem completa
%de tamanho NP(1) x NP(2) que estao na celula de posicao cpos da malha
%completa com NC(1) x NC(2) celulas. 

KP = NP ./ NC;
assert(max(mod(NP,NC)) == 0)
ppos0 = KP .* cpos; %posicao do primeiro ponto na grade completa
np = 0;
for dx = 0:KP(1) - 1
    for dy = 0:KP(2) - 1
        ppos = ppos0 + [dx, dy];
        ip = ppos(1)*NP(2) + ppos(2) + 1;
        np = np + 1;
        ixgpontos(np) = ip;
    end 
end
        
    