function [p,g,PR] = obtem_centros_e_medias_celulares(K,malha,...
    CD,LD,p_comp,f_comp)
%devolve  a lista p(nc x 2)das coordenadas dos centros das celulas cujas 
%posicoes estao na lista K(nc x 2), 
%e a lista g(nc x nf) das medias da funcao
%nessas celulas, onde nc eh o numero de celulas e nf o numero de colunas de
%f_comp. Supoe que os indices de pontos em cada celula se referem aas
%linhas de p_comp e f_comp. Tambem devolve um vetor PR tal que PR(i) eh o
%indice do centro p(i) na lista de todos os centros em ordem de coluna.  

np = size(p_comp,1);
assert(size(p_comp,2) == 2)
nf = size(f_comp,2);
assert(size(f_comp,1) == np)
NC = malha.NC;
nc = nnz(malha.ixc);
MD = CD - 0.5*LD; %canto inferior do dominio
LD_c = (LD ./ malha.NC); %tamanho da celula 
nk = size(K,1);
for i = 1:nk
    posi = K(i,:);
    icel = malha.ixc(posi(1)+1,posi(2)+1); 
    assert(icel > 0, 'celula inexistente')
    assert(icel <= nc)
    celi = malha.celulas(icel);
    Ci = ((posi + [0.5 0.5]) .* LD_c) + MD;
    p(i,:) = Ci;
    pci = p_comp(celi.ixgpontos,:);
    fci = f_comp(celi.ixgpontos,:);
    g(i,:) = media_celular(pci,fci,Ci);
    PR(i) = 1 + posi(1)*NC(2) + posi(2);
end
assert(size(p,1) == nk)
assert(size(p,2) == 2)
assert(size(g,1) == nk)
assert(size(g,2) == nf)



