function A0 = obtem_coluna_padrao_da_matriz_A(tipobase,raio_abs,...
    tensorial,CD,LD,NC,KP,leia_matriz)
%Obtem a coluna zero da matriz da base uniforme com os parametros
%especificados.
%Se possivel tenta ler do disco, em vez de calcular.
%Supoe uma grade de amostragem completa
%e regular com NP(1) x NP(2) pontos.

%No disco sempre gravamos a coluna da matriz A correspondente ao
%elemento de posicao [0, 0] supondo uma grade de amostragem completa
%com os pontos armazenados por colunas no dominio todo.

raio_rel_dom = raio_abs ./ LD;  %raio relativo ao dominio
NP = NC .* KP;
np_comp = prod(NP);

dir1 = sprintf('tb%02d-ten%d-dob%d',tipobase,...
    tensorial,1);
dir2 = sprintf('rx%08.5f-ry%08.5f-NX%04d-NY%04d',...
    raio_rel_dom(1),raio_rel_dom(2),NP(1),NP(2));
pasta = cria_pasta(sprintf('~/Desktop/matrizes/%s/%s',dir1,dir2));
if leia_matriz
    fprintf(2,'lendo a coluna padrao da matriz A da pasta %s\n',pasta);
    A0 = le_matriz(pasta,'A0',np_comp,1);
    fprintf(2,'tamanho = %d x %d elementos nao nulos = %d\n', ...
        size(A0), nnz(A0));
end
if (~leia_matriz) || (nnz(A0) == 0)
    fprintf(2,'construindo a grade completa de amostragem p_t\n');
    p_t = constroi_grade_de_amostras(CD,LD,NP);
    assert(size(p_t,1) == np_comp)
    fprintf(2,'calculando a coluna padrao da matriz A \n');
    centro = centro_da_celula([0, 0],CD,LD,NC);
    A0 = discretiza_em_grade_regular_coluna_padrao_da_matriz_A(...
        NC,NP,p_t,centro,raio_abs,tipobase,tensorial,...
        malha_t.LD);
    fprintf(2,'gravando a coluna padrao de A na pasta %s\n',pasta);
    grava_matriz(pasta,'A0',A0)
end
A0 = sparse(A0);
assert(size(A0,1) == NP(1)*NP(2))
