function PR = obtem_indices_dos_pontos_das_celulas(malha,S)
%devolve uma lista PR com os indices no vetor de pontos de amostragem global
%de todos os pontos contidos nas celulas da malha cujas posicoes estao na
%lista S.

np = 0;
ns = size(S,1);
nc = nnz(malha.ixc);
PR = zeros(1,0);
for i = 1:ns
    posi = S(i,:);
    icel = malha.ixc(posi(1)+1, posi(2)+1);
    assert(icel > 0, 'celula inexistente')
    assert(icel <= nc)
    celi = malha.celulas(icel);
    npc = size(celi.ixgpontos,2);
    if npc > 0
        j_ini = np + 1;
        j_fim = np + npc;
        PR(1,j_ini:j_fim) = celi.ixgpontos;
    end
    np = np + npc;
end