function [A0,A] = obtem_matriz_A(parametros,p,malha,base,...
    tensorial,NP,np_comp,PRbase)
%Supoe que p eh o 
%conjunto de pontos de amostragem a usar para essa malha e que todos os
%pontos estao dentro da uniao D' das celulas da malha. Supoe que o suporte de 
%todo elemento da base esta contido em D'. Se possivel tenta ler a matriz 
%da base, em vez de calcular. O elemento
%PRbase(k) deve ser o indice do ponto p(k) na grade de amostragem completa
%e regular com NP(1) x NP(2) pontos. 
%Pode devolver um vetor coluna A0 que eh a coluna zero da matriz A
%calculada para a grade completa regular de pontos de amostragem.

np = size(p,1);
assert(size(PRbase,2) == np) 
nb = size(base.elementos,2);
assert(parametros.tensorial == tensorial);

if  (base.uniforme) && (~isnan(NP(1)))
    assert(~isnan(NP(1)))
    assert(~isnan(NP(2)))
    %Supoe que p eh um subconjunto da grade de amostragem completa regular
    %com NP(1) x NP(2) pontos cujos indices estao em PRbase. Supoe tambem
    %que 
    %todos os elementos da base sao copias transladadas do mesmo elemento.
    %O vetor p pode estar em qualquer ordem
    
    %Vamos tentar ler do disco ou entao calcular o elemento de posicao
    %zero, para todos os pontos da grade de amostragem completa,
    %e replicar seus valores relevantes para os elementos da base.
    %No disco sempre gravamos a coluna da matriz A correspondente ao
    %elemento de posicao [0, 0] supondo uma grade de amostragem completa 
    %com os pontos armazenados por colunas no dominio todo.
    
    raio_abs = base.elementos(1).raio_abs;
     tipobase = base.elementos(1).tipobase;
    assert(base.elementos(1).tipobase == parametros.tipobase) 
    raio_rel_dom = raio_abs ./ malha.LD;  %raio relativo ao dominio
    
    assert(np_comp == prod(NP)) %numero de pontos na grade de amostragem completa
    
    dir1 = sprintf('tb%02d-ten%d-dob%d',tipobase,...
        parametros.tensorial,1);
    dir2 = sprintf('rx%08.5f-ry%08.5f-NX%04d-NY%04d',...
        raio_rel_dom(1),raio_rel_dom(2),NP(1),NP(2));
    pasta = cria_pasta(sprintf('~/Desktop/matrizes/%s/%s',dir1,dir2));
    if parametros.le_matriz
        fprintf(2,'lendo a coluna padrao da matriz A da pasta %s\n',pasta);
        A0 = le_matriz(pasta,'A0',np_comp,1);
        fprintf(2,'tamanho = %d x %d elementos nao nulos = %d\n', ...
            size(A0), nnz(A0));
    end
    if (~parametros.le_matriz) ||(nnz(A0) == 0)
        fprintf(2,'construindo a grade completa de amostragem p_t\n');
        p_t = constroi_grade_de_amostras(malha.CD,malha.LD,NP);
        assert(size(p_t,1) == np_comp)
        fprintf(2,'calculando a coluna padrao da matriz A \n');
        centro = centro_da_celula([0, 0],malha.CD,malha.LD,malha.NC);
        A0 = discretiza_em_grade_regular_coluna_padrao_da_matriz_A(...
            malha.NC,NP,p_t,centro,raio_abs,tipobase,tensorial,...
            malha.LD);
        assert(size(A0,1) == NP(1)*NP(2))
        figure(97)
        plota_funcao(p_t,A0,true,malha.CD,malha.LD,NP,NaN,NaN);
        disp('Calculou o A0')
        %pause
        fprintf(2,'gravando a coluna padrao de A na pasta %s\n',pasta);
        grava_matriz(pasta,'A0',A0)
    end
    
    fprintf(2,'preenchendo a matriz A \n');
    A = replica_coluna_da_matriz_A(A0,malha.NC,base,NP,PRbase);
    assert(size(A,1) == np)
    assert(size(A,2) == nb)
%     for j = 1:nb
%         if norm(base.elementos(j).pos,1) == 0
%             fprintf(2,'plotando o elemento %d da base\n',j);
%             figure(96)
%             plota_funcao(p,A(:,j)-A0(PRbase,:),true,...
%                 malha.CD,malha.LD,NP,NaN,NaN);
%         end
%     end
    confere_matriz_A(A,p,malha,base,tensorial);
else
    fprintf(2,'calculando a matriz A\n');
    A = discretiza_base(p,malha,base,tensorial,np_comp,PRbase);
    assert(size(A,1) == np)
    assert(size(A,2) == nb)
    A0 = sparse(np_comp,1); %coluna de zeros
end


