function Aj_redu = permuta_coluna_da_matriz_A(A0,posj,NC,NP,RPbase,np_redu)

%determina a coluna Aj_redu de A referente ao elemento da base completa com
%posicao posj, supondo a grade de amostragem reduzida. Supoe que essa grade
%tem np_redu pontos e que RPbase(i) eh o indice na grade reduzida do ponto
%p(i) da grade de amonstragem completa. Supoe que a grade de amonstragem
%completa tem NP(1) x NP(2) pontos e que a base completa tem NC(1) x NC(2)
%elementos.

debuga = false;%(posj(1) == 11) && (posj(2) == 18);
np_comp = prod(NP);
assert(size(A0,1) == np_comp)
assert(max(mod(NP,NC)) == 0)
KP = NP ./ NC;
Aj_redu = sparse(np_redu,1);
deltaxj = posj(1)*KP(1);
deltayj = posj(2)*KP(2);
ixA0 = (find(A0))';
for i0 = ixA0
    % i0 eh o indice na grade completa de um ponto onde
    %o elemento zero nao eh nulo. Determina o indice ij do ponto
    %correspondente do elemento j.
    dy0 = mod(i0-1,NP(2)); %indice relativo do ponto i0 dentro da coluna da grade
    dx0 = (i0-1-dy0)/NP(2); %indice relativo da coluna do ponto i0 na grade
    dxj = mod(dx0+deltaxj,NP(1));
    dyj = mod(dy0+deltayj,NP(2));
    ij = 1 + dxj*NP(2) + dyj;
    assert((ij >= 1) && (ij <= np_comp))
    ij_redu = full(RPbase(1,ij));
    if debuga 
        fprintf(2,'%d = [%d %d] --> [%d %d] = %d --> %d\n',...
            i0,dx0,dy0,dxj,dyj,ij,ij_redu);
    end
    if ij_redu ~= 0
        assert((ij_redu >= 1) && (ij_redu <= np_redu))
        Aj_redu(ij_redu,1) = A0(i0,1);
    end
end
%fprintf(2,'elemento %d, nao nulos = %d',j,nnz(Aj_redu));