function v = phi_mae(x,y,tipok,LX_rel,LY_rel)
%calcula funcao mae bidimensional(raio absoluto 1)
%no argumento (x,y). 
%supoe dominio toroidal com periodo (LX_rel,LY_rel) e calcula por somatoria 
%de copias
%Note que (LX_rel, LY_rel) sao as dimensoes absolutas do dominio dividas pelos 
%respectivos raios.

% if dobrado
    while (x < -LX_rel/2); x = x + LX_rel; end
    while (x > LX_rel/2); x = x - LX_rel; end
    while (y < -LY_rel/2); y = y + LY_rel; end 
    while (y > LY_rel/2); y = y - LY_rel; end

    mx = psi_num_termos(tipok,LX_rel);
    my = psi_num_termos(tipok,LY_rel);
    assert((mx <= 10) && (my <= 10), 'este tipo de funcao nao pode ser dobrado')
% else
%     mx = 0;
%     my = 0;
%end
v = 0;
mx = mx + 1;
my = my + 1;
for ix = -mx:mx
    for iy = -my:my
        xi = x + ix*LX_rel;
        yi = y + iy*LY_rel;
        ri = hypot(xi,yi);
        vi = funcao_mae(ri,tipok);
        v = v + vi;
        if (abs(ix) == mx) || (abs(iy) == my)
            assert(vi == 0)
        end
    end
end