function plota_centros(base,p,A,malha,NP,parametros,pasta,plota,estagio)

nb = size(base.elementos,2);
np = size(p,1);
eps = 0.001*max(malha.LD./malha.NC);
coberto = zeros(1,np);
for k = 1:np
    if nnz(A(k,:)) > 0
        coberto(1,k) = 1;
    end
end

if (~isnan(NP(1)))
    %pinta o suporte real (pontos onde a base eh diferente de zero)
    pwh = malha.LD./NP; %tamanho das celulas de p
    for k = 1:np
        if coberto(1,k) ~= 0
            cp = p(k,:) - 0.5*pwh; %canto da celula de p(k)
            hold on
            rectangle('Position',[cp(1),cp(2),pwh(1),pwh(2)],...
                'FaceColor',[0.9, 1.0 0.8], 'EdgeColor','none')
        end
    end
end

for i =1:nb
    C = base.elementos(i).centro;
    R = base.elementos(i).raio_abs;
    plota_centro_e_raio(C(1,1),C(1,2),R(1,1),R(1,2),parametros.tensorial,eps)
end

% title(sprintf('centros dos elementos %s',...
%     estagio),'FontSize',20);
axis equal
pmin = malha.CD - 0.5*malha.LD;
pmax = malha.CD + 0.5*malha.LD;
xlim([pmin(1), pmax(1)]);
ylim([pmin(2), pmax(2)]);
hold off
if plota.salva_eps
    saveas(gcf,sprintf('%s/centros.eps',pasta));
end






