function plota_centros_de_nivel_hier2(base,p,A,malha,NP,...
    parametros,lin,col,suporte)


nb = size(base.elementos,2);
np = size(p,1);
NX = NP(1);
NY = NP(2);
%calcula o deslocamento deste nivel
DD = ((malha.LD*1.1) .* [col, lin]) + malha.LD*0.05;
%pequena pertubacao nos contornos das celulas
eps = 0.001*max(malha.LD ./ malha.NC);

%plota o dominio
hold on
rectangle('Position',[DD(1),DD(2),malha.LD(1),malha.LD(2)],...
    'FaceColor',[1.0, 0.9 0.8], 'EdgeColor','none')
if suporte
    %plota os suportes de todos os elementos
    pwh = malha.LD./NP; %tamanho das celulas de p
    coberto = zeros(1,np);
    for k = 1:np
        if nnz(A(k,:)) > 0
            coberto(1,k) = 1;
        end
    end
    
    for k = 1:np
        if coberto(1,k) ~= 0
            cp = p(k,:) - 0.5*pwh + DD; %canto da celula de p(k)
            hold on
            rectangle('Position',[cp(1),cp(2),pwh(1),pwh(2)],...
                'FaceColor',[0.9, 1.0 0.8], 'EdgeColor','none')
        end
    end
end

%plota celulas principais e os centros
for i =1:nb
    C = base.elementos(i).centro;
    %R = base.elementos(i).raio_abs;
    posi = base.elementos(i).pos;
    plota_celula_e_centro(posi,malha.CD+DD,malha.LD,malha.NC,C+DD,eps)
end
