function plota_funcao(p,f,media,CD,LD,NP,zmin,zmax)
%Plota a funcao cujo valor eh f(i) no ponto p(i,1:2), para todo i.
%CD centro da regiao e LD tamanho da regiao.
%Se zmin e zmax sao NaN a propria funcao calcula o intervalo.
%se media for true plota a media dos pontos em cada celula, senao plota o
%maior valor absoluto em cada celula.

np = size(p,1);
assert(size(f,1) == np)
assert(size(f,2) == 1)
NG_max = 90;

%decide o tamanho NG da grade de plotagem
if (isnan(NP(1)))
    fprintf(2,'plotando pontos irregulares\n');
    NG = [NG_max NG_max];
elseif NP(1) <= NG_max && NP(2) <= NG_max
    fprintf(2,'plotando pontos individuais\n');
    NG = NP;
else
    div = escolhe_passo_de_plot(NP(1),NP(2),NG_max);
    if div == 0
        fprintf(2,'nao encontrou divisor comum, plota como irregulares\n');
        NG = [NG_max NG_max];
    else
        fprintf(2,'plotando a cada %d pontos\n',div);
        NG = NP / div;
    end
end
LG = LD ./ NG; %tamanho de uma celula do plot
MD = CD - 0.5*LD; %canto inferior do dominio
xv = ((1:NG(1))-0.5)*LG(1) + MD(1);
yv = ((1:NG(2))-0.5)*LG(2) + MD(2);

[xg,yg] = meshgrid(xv,yv);
fg = zeros(NG(1),NG(2)); %soma ou max em cada celula do plot
ng = zeros(NG(1),NG(2)); %numero de dados em cada celula do plot

for i = 1:np
    valor = f(i,1);
    xi = p(i,1);
    yi = p(i,2);
    assert((xi >= MD(1)) && (xi < MD(1)+LD(1)))
    assert((yi >= MD(2)) && (yi < MD(2)+LD(2)))
    %determina a posicao da celula do plot que contem o ponto
    pos = floor(([xi, yi] - MD) ./ LG);
    assert(pos(1) >= 0)
    assert(pos(1) < NG(1))
    assert(pos(2) >= 0)
    assert(pos(2) < NG(2))
    ix = pos(1)+1;
    iy = pos(2)+1;
    if media
        fg(ix,iy) = fg(ix,iy) + valor;
        ng(ix,iy) = ng(ix,iy) + 1;
    else
        fg(ix,iy) = max(fg(ix,iy),abs(valor));
    end
end

if media
    for ix = 1:NG(1)
        for iy = 1:NG(2)
            if ng(ix,iy) == 0
                fg(ix,iy) = 0;
            else
                fg(ix,iy) = fg(ix,iy)/ng(ix,iy);
            end
        end
    end
end
pmin = CD - 0.505*LD;
pmax = CD + 0.505*LD;
xlim([pmin(1), pmax(1)]);
ylim([pmin(2), pmax(2)]);

surf(xg,yg,fg);
define_zlim(fg,zmin,zmax);
set(gca,'Fontsize', 20)
