function plota_funcao_irreg(p,f,CD,LD,zmin,zmax)

%Plota a funcao cujo valor eh f(i) no ponto p(i,1:2), para todo i, supondo
%pontos irregulares.
%CD centro da regiao e LD tamanho da regiao.
%Se zmin e zmax sao NaN a propria funcao calcula o intervalo.

np = size(p,1);
assert(size(f,1) == np)
assert(size(f,2) == 1)

MD = CD - 0.5*LD; %canto inferior do dominio
xv = [p(:,1)'; p(:,1)'];
yv = [p(:,2)'; p(:,2)'];

zv = [zeros(1,np); f(:,1)'];
plot3(xv,yv,zv,'m');
hold on
plot3(xv(2,:),yv(2,:),zv(2,:),'b.','markersize',6.5);
plot3(xv(1,:),yv(1,:),zv(1,:),'m.','markersize',6);
define_zlim(zv,zmin,zmax);
set(gca,'Fontsize', 20)
pmin = CD - 0.505*LD;
pmax = CD + 0.505*LD;
xlim([pmin(1), pmax(1)]);
ylim([pmin(2), pmax(2)]);
hold off
