function plota_malha_de_nivel_hier2(malha,lin,col)

%calcula o deslocamento deste nivel 
DD = ((malha.LD*1.1) .* [col, lin]) + malha.LD*0.05;

%plota o dominio
hold on
rectangle('Position',[DD(1),DD(2),malha.LD(1),malha.LD(2)],...
            'FaceColor',[1.0, 0.9 0.8], 'EdgeColor','none')

%plota todas as celulas
eps = 0.001*max(malha.LD ./ malha.NC);
[I, J] = find(malha.ixc);
nc = size(I,1);

for i = 1:nc
    posi = [I(i)-1, J(i)-1];
    plota_celula(posi,malha.CD+DD,malha.LD,malha.NC,eps)
end
