function plota_mapa_de_erro_uniforme(p,map,CD,LD,NP,KP,zmin,zmax)
%Plota o mapa de erro cujo valor eh map(i) no ponto p(i,1:2), para todo i 
%dentro de uma celula. Supoe que o mapa deriva de uma base uniforme com
%espaco objetivo tambem uniforme de modo que o mapa de erro eh igual em
%todas as celulas. Supoe que p eh uma grade de amostragem completa regular 
%com NP(1) x NP(2) pontos sendo que cada celula contem KP(1) x KP(2)
%pontos.
%CD centro da regiao e LD tamanho da regiao.
%Se zmin e zmax sao NaN a propria funcao calcula o intervalo.


np = size(p,1);
assert(size(map,1) == np)
assert(size(map,2) == 1)
assert(max(mod(NP,KP)) == 0)

NC = NP ./ KP; %numero de celulas da malha em cada eixo

%decide o tamanho NG da grade de plotagem 
NG = KP; 
assert(~isnan(NP(1)))
assert(~isnan(NP(2)))

LG = LD ./ NC; %tamanho de uma celula da grade da malha
LK = LD ./ NP; %espacamento entre os pontos de amostragem 
MD = CD - 0.5*LD; %canto inferior do dominio
xv = ((1:NG(1))-0.5)*LK(1) + MD(1);
yv = ((1:NG(2))-0.5)*LK(2) + MD(2);

[xg,yg] = meshgrid(xv,yv);
fg = zeros(NG(1),NG(2)); %soma ou max em cada celula do plot

for ix = 1:NG(1)
    for iy =1:NG(2)
        i = 1 + (ix-1)*NP(2) + (iy - 1);
        xi = p(i,1);
        yi = p(i,2);
        assert(hypot(xi-xv(ix),yi-yv(iy)) < 1.0e-8)
        valor = map(i,1);
        fg(ix,iy) = valor;
    end
end
surf(xg,yg,fg);
define_zlim(fg,zmin,zmax);
set(gca,'Fontsize', 20)
