function plota_pontos(p,CD,LD)
%plota os pontos de amostragem p(i,1:2), para todo i.
%CD centro da regiao e LD tamanho da regiao.

np = size(p,1);
assert(size(p,2) == 2)

MD = CD - 0.5*LD; %canto inferior do dominio
axis equal
pmin = CD - 0.5*LD;
pmax = CD + 0.5*LD;
xlim([pmin(1), pmax(1)]);
ylim([pmin(2), pmax(2)]);
for i = 1:np
    xi = p(i,1);
    yi = p(i,2);
    assert((xi >= MD(1)) && (xi < MD(1)+LD(1)))
    assert((yi >= MD(2)) && (yi < MD(2)+LD(2)))
    hold on
    plot(xi,yi,'+')
end
%set(gca,'Fontsize', 20)
