function d_min = primeira_celula_do_suporte(NS,NC)
%devolve a posicao da primeira celula do suporte do elemento de posicao 
%(0,0). Se o suporte cobrir o dominio inteiro, devolve (0,0) caso contrario
%devolve [-hx, -hy] onde hx = (NS(1)-1)/2, e igualmente para hy.
if (NS(1) < NC(1)) 
    hx = (NS(1) - 1)/2;
    dx_min = -hx;
else
    dx_min = 0;
end
if (NS(2) < NC(2)) 
    hy = (NS(2) - 1)/2;
    dy_min = -hy;
else
    dy_min = 0;
end
d_min = [dx_min, dy_min];