function principal_avalia_adaptativa(parametros,plota)
%avalia aproximacao com base radial ou tensorial adaptativa com centros em
%uma grade regular

assert(parametros.funcao > 0);

%define malha completa
fprintf(2,'definindo a malha regular completa\n');
assert(parametros.dim_dominio == 2);
LD = parametros.tam_dominio;
CD = 0.5*LD;

%define os pontos de amostragem
%assert(parametros.n_pontos == 0)
NC = parametros.tam_grade_centros;
KP = calcula_pontos_por_celula(parametros.pts_por_celula,LD,NC);
NP = KP .* NC;
p = constroi_grade_de_amostras(CD,LD,NP);
np = size(p,1);
np_comp = np;
malha = constroi_malha_completa(CD,LD,NC,p);
nc = nnz(malha.ixc);
fprintf(2,'numero de celulas %d\n',nc);

%define as pastas para os plotes 
sigla_metodo = ['MQ';'SS'; 'SO'; 'WQ'];
pasta_raiz = cria_pasta(sprintf(...
    '~/Desktop/dout2012/Texto/Comum/E4-ADfimvinteC-F%02d',parametros.funcao));
dir1 = sprintf('tb%02d-ten%d-dob%d-gs%d',parametros.tipobase,...
    parametros.tensorial,1,0);
dir2 = sprintf('TX%04d-TY%04d-NX%05d-NY%05d',NC(1),NC(2),NP(1),NP(2));
pasta_tipobase = cria_pasta(sprintf('%s/%s/%s',...
    pasta_raiz,dir1,dir2));
pasta_tipobase_metodo = cria_pasta(sprintf('%s/%s',...
    pasta_tipobase,sigla_metodo(parametros.metodo,:)));

%constroi a matriz f da funcao a aproximar
%f(i,j) valor da funcao numero j ( = 1) no ponto de amostragem i
f = discretiza_funcao(parametros,p,CD,LD);
nf = 1;
if plota.funcao
    figure(9);
    for j = 1:nf
        plota_funcao(p,f(:,j),true,CD,LD,NP,NaN,NaN);
        %define_zlim2(alpha,f,s);
        %title(sprintf('funcao %d',parametros.funcao),'FontSize',20);
        title(sprintf('funcao'),'FontSize',20);
        hold off
        if plota.salva_eps
            saveas(gcf,sprintf('%s/fg%04d.eps',pasta_raiz,j));
        end
        %         pause(1)
    end
end

%tamanho da base inicial aqui eh igual ao numero de celulas:
nb = nc; 

assert(parametros.raios == parametros.raio)
raio_rel = parametros.raio;

arq = fopen(sprintf('%s/parametros.tex',pasta_tipobase),'wt');
fprintf(arq,'\\newcommand{\\PARMtamdomX}{%d}\n',parametros.tam_dominio(1));
fprintf(arq,'\\newcommand{\\PARMtamdomY}{%d}\n',parametros.tam_dominio(2));
fprintf(arq,'\\newcommand{\\PARMtensorial}{%d}\n',parametros.tensorial);
%fprintf(arq,'\\newcommand{\\PARMdobrado}{%d}\n',parametros.dobrado);
fprintf(arq,'\\newcommand{\\PARMptporcelX}{%d}\n',KP(1));
fprintf(arq,'\\newcommand{\\PARMptporcelY}{%d}\n',KP(2));
fprintf(arq,'\\newcommand{\\PARMptporcelula}{%d}\n',KP(1)*KP(2));
fprintf(arq,'\\newcommand{\\PARMamostrX}{%d}\n',NP(1));
fprintf(arq,'\\newcommand{\\PARMamostrY}{%d}\n',NP(2));
fprintf(arq,'\\newcommand{\\PARMamostras}{%d}\n',np);
fprintf(arq,'\\newcommand{\\PARMcentrosX}{%d}\n',NC(1));
fprintf(arq,'\\newcommand{\\PARMcentrosY}{%d}\n',NC(2));
fprintf(arq,'\\newcommand{\\PARMdimA}{%d}\n',nb);
fprintf(arq,'\\newcommand{\\PARMraio}{%s}\n',...
    converte_raio_tex(raio_rel));
fclose(arq);

fprintf(2,'--- aproxicao uniforme -------------\n');
estagio = '(unif)';    
plota.janela_base = 10;
pasta_raio = cria_pasta(sprintf('%s/r%08.5f',...
    pasta_tipobase,raio_rel));
pasta_raio_metodo = cria_pasta(sprintf('%s/%s',...
    pasta_raio,sigla_metodo(parametros.metodo,:)));

%calcula o raio absoluto em cada eixo
assert(NC(1) == LD(1))
assert(NC(2) == LD(2))
raio_abs = [raio_rel raio_rel]; 

base = constroi_base(malha,[],raio_abs,parametros.tipobase);
%mostra_base(base)

profile on
PRbase = 1:np; %use todo o p
[A,M] = obtem_base_discreta(parametros,p,malha,base,...
    parametros.tensorial,KP,NP,np_comp,PRbase);
profile viewer
if plota.base
    plota_base(parametros,malha,NP,p,A,base,pasta_raio,...
        plota,estagio);
end

%o problema eh aproximar o vetor f por uma combinacao linear das
%colunas da matriz A
grava_tex = true;
[b,alpha,s,e,map,condM] = aproximacao(parametros,NP,...
        p,np_comp,CD,LD,base,A,f,M,pasta_raio_metodo,plota,estagio,grava_tex);
erro_L2 = norma_erro_L2(map,np_comp);
erro_Linf = norma_erro_Linf(map);
fprintf(2,'norma do erro = %9.6f (L2) %9.6f (Linf)\n', erro_L2, erro_Linf);

fprintf(2,'--- aproximacao adaptativa -------------\n');
estagio = '(adap)';
plota.janela_base = 30;
pasta_raio_metodo = cria_pasta(sprintf('%s/%s-a',...
    pasta_raio,sigla_metodo(parametros.metodo,:)));
plota.base_dual = false;
assert(nf == 1)
[ix_a,base_a,A_a,alpha_a] = escolhe_sub_base(parametros,base,A,alpha,e);
M_a = M(ix_a,ix_a);
nb_a = size(A_a,2);
fprintf(2,'tam base adaptativa %d\n',nb_a);
figure(100); clf;
plota_centros(base_a,p,A_a,malha,NP,parametros,pasta_raio_metodo,...
    plota,estagio)
%calcula residuo com coeficientes originais e base reduzida
s_a = A_a*alpha_a;
e_a = f - s_a;
assert(nf == 1)
erro_a_L2 = norma_erro_L2(e_a,np_comp);
erro_a_Linf = norma_erro_Linf(e_a);
fprintf(2,'erro com base reduzida e alphas originais %9.6f (L2) %9.6f (Linf)\n',...
    erro_a_L2, erro_a_Linf);

fprintf(2,'--- recalculando coeficientes com base reduzida -------------\n');
[b_a,alpha_a,s_a,e_a,map_a,condM_a] = ...
        aproximacao(parametros,...
        NP,p,np_comp,CD,LD,base_a,A_a,f,M_a,pasta_raio_metodo,...
        plota,estagio,grava_tex);
erro_a_L2 = norma_erro_L2(map_a,np_comp);
erro_a_Linf = norma_erro_Linf(map_a);

fprintf(2,'erro com base adaptativa e alphas recalculados %9.6f (L2) %9.6f (Linf)\n',...
    erro_a_L2, erro_a_Linf);
arq = fopen(sprintf('%s/paramadapt.tex',pasta_raio_metodo),'wt');
fprintf(arq,'\\newcommand{\\PARMerroaHilb}{%s}\n',...
        converte_erro_tex(erro_a_L2));
    fprintf(arq,'\\newcommand{\\PARMerroaLinf}{%s}\n',...
        converte_erro_tex(erro_a_Linf));
fprintf(arq,'\\newcommand{\\PARMtol}{%s}\n',...
    converte_erro_tex(parametros.tol));
fprintf(arq,'\\newcommand{\\PARMnba}{%d}\n',nb_a);
fclose(arq);
