function principal_avalia_uniforme(parametros,plota)
%avalia aproximacao com base radial ou tensorial com centros em
%uma grade regular

%define malha completa
fprintf(2,'definindo a malha regular completa\n');
assert(parametros.dim_dominio == 2);
LD = parametros.tam_dominio;
CD = 0.5*LD;

%define os pontos de amostragem
assert(parametros.n_pontos == 0)
NC = parametros.tam_grade_centros;
KP = calcula_pontos_por_celula(parametros.pts_por_celula,LD,NC);
NP = KP .* NC;
p = constroi_grade_de_amostras(CD,LD,NP);
np = size(p,1);
np_comp = np;
malha = constroi_malha_completa(CD,LD,NC,p);
nc = nnz(malha.ixc);
fprintf(2,'numero de celulas %d\n',nc);

%define as pastas para os plotes
sigla_metodo = ['MQ';'SS'; 'SO'; 'WQ'];
pasta_raiz = cria_pasta(sprintf(...
    '~/Desktop/dout2012/Texto/Comum/E4-U-F%02d',parametros.funcao));
dir1 = sprintf('tb%02d-ten%d-dob%d-gs%d',parametros.tipobase,...
    parametros.tensorial,1,0);
dir2 = sprintf('TX%04d-TY%04d-NX%05d-NY%05d',NC(1),NC(2),NP(1),NP(2));
pasta_tipobase = cria_pasta(sprintf('%s/%s/%s',...
    pasta_raiz,dir1,dir2));
pasta_tipobase_metodo = cria_pasta(sprintf('%s/%s',...
    pasta_tipobase,sigla_metodo(parametros.metodo,:)));
assert(parametros.dim_dominio == 2)

nr = size(parametros.raios,2);
erro_graf = zeros(nr,1);
raio_graf = zeros(nr,1);
condM_graf = zeros(nr,1);
somavM_graf = zeros(nr,1);

%constroi a matriz f das funcoes a aproximar
%f(i,j) valor da funcao numero j no ponto de amostragem i
%freq(j) frequencia absoluta da funcao numero j
if parametros.funcao == 0
    %constroi base ortogonal do espaco objetivo \CF
    assert(parametros.tam_grade_centros(1) == ...
        parametros.tam_grade_centros(2));
    fmax_x = floor((parametros.tam_grade_centros(1) - 1)/2);
    fmax_y = floor((parametros.tam_grade_centros(2) - 1)/2);
    fprintf(2,'construindo a base de Hartley com %d x %d elementos\n',...
        fmax_x,fmax_y);
    nf = 0;
    sigma_f = 1/3;
    ff_esp = [];
    for fx = -fmax_x:fmax_x
        for fy = -fmax_y:fmax_y
            rf2 = (fx/fmax_x)^2 + (fy/fmax_y)^2;
            if rf2 < (0.8)^2
                wf = exp(-0.5*rf2/(sigma_f^2));
                nf = nf + 1;
                f(:,nf) = wf*onda_hartley(fx,fy,p,CD,LD);
                %g(:,nf) = wf*onda_hartley(fx,fy,C',CD,LD);
                ff_esp(nf) = wf*wf;
                freq(1,nf) = hypot(fx,fy);
            end
        end
    end
    %    assert(nf <= nb)
    e_ort = norm(f'*f - diag(ff_esp),2);
    fprintf(2,'erro de ortogonalidade da base de Cal{F} %e\n',e_ort);
    
    if plota.funcao
        ng = 4; %numero de exemplos a plotar
        for j = 1:ng
            %constroi um elemento aleatorio do conjunto F_1
            beta = randn(nf,1);
            beta = beta/norm(beta,2);
            g(:,j) = f*beta;
            figure(9);
            plota_funcao(p,g(:,j),true,CD,LD,NP,NaN,NaN);
            %define_zlim2(alpha,f,s);
            title(sprintf('funcao exemplo %d de F_1',j),'FontSize',20);
            hold off
            if plota.salva_eps
                saveas(gcf,sprintf('%s/f%04d.eps',pasta_raiz,j));
            end
%            pause
        end
    end
    
else
    %constroi o vetor valores da funcao
    f = discretiza_funcao(parametros,p,CD,LD);
    assert(size(f,2) == 1)
    freq = NaN;
    nf = 1;
    if plota.funcao
        figure(9);
        for j = 1:nf
            plota_funcao(p,f(:,j),true,CD,LD,NP,NaN,NaN);
            %define_zlim2(alpha,f,s);
            title(sprintf('funcao %d',j),'FontSize',20);
            hold off
            if plota.salva_eps
                saveas(gcf,sprintf('%s/f%04d.eps',pasta_raiz,j));
            end
            %         pause(1)
        end
    end
end
%tamanho da base aqui eh igual ao numero de celulas:
nb = nc; 

nomearq = sprintf('%s/parametros.tex',pasta_tipobase);
fprintf(2,'gravando parametros em %s\n',nomearq); 
arq = fopen(nomearq,'wt');
fprintf(arq,'\\newcommand{\\PARMtamdomX}{%d}\n',parametros.tam_dominio(1));
fprintf(arq,'\\newcommand{\\PARMtamdomY}{%d}\n',parametros.tam_dominio(2));
fprintf(arq,'\\newcommand{\\PARMtensorial}{%d}\n',parametros.tensorial);
%fprintf(arq,'\\newcommand{\\PARMdobrado}{%d}\n',parametros.dobrado);
fprintf(arq,'\\newcommand{\\PARMdimF}{%d}\n',nf);
fprintf(arq,'\\newcommand{\\PARMptporcelX}{%d}\n',KP(1));
fprintf(arq,'\\newcommand{\\PARMptporcelY}{%d}\n',KP(2));
fprintf(arq,'\\newcommand{\\PARMptporcelula}{%d}\n',KP(1)*KP(2));
fprintf(arq,'\\newcommand{\\PARMamostrX}{%d}\n',NP(1));
fprintf(arq,'\\newcommand{\\PARMamostrY}{%d}\n',NP(2));
fprintf(arq,'\\newcommand{\\PARMamostras}{%d}\n',np);
fprintf(arq,'\\newcommand{\\PARMcentrosX}{%d}\n',NC(1));
fprintf(arq,'\\newcommand{\\PARMcentrosY}{%d}\n',NC(2));
fprintf(arq,'\\newcommand{\\PARMdimA}{%d}\n',nb);
fclose(arq);


for ir = 1:nr
    fprintf(2,'--- iteracao com o raio numero %d -------------\n',ir);
    parametros.raio = parametros.raios(ir);
    raio_rel = parametros.raio;
    raio_graf(ir,1) = raio_rel;
    
    fprintf(2,'--- aproxicao uniforme -------------\n');
    estagio = sprintf('raio %8.6f',raio_rel);
    plota.janela_base = 10;
    pasta_raio = cria_pasta(sprintf('%s/r%08.5f',...
        pasta_tipobase,raio_rel));
    pasta_raio_metodo = cria_pasta(sprintf('%s/%s',...
        pasta_raio,sigla_metodo(parametros.metodo,:)));
    
    nomearq = sprintf('%s/parametros.tex',pasta_raio);
    fprintf(2,'gravando parametros em %s\n',nomearq); 
    arq = fopen(nomearq,'wt');
    fprintf(arq,'\\newcommand{\\PARMraio}{%s}\n',...
        converte_raio_tex(raio_rel));
    
    %calcula o raio absoluto em cada eixo
    assert(NC(1) == LD(1))
    assert(NC(2) == LD(2))
    raio_abs = [raio_rel raio_rel];
    
    base = constroi_base(malha,[],raio_abs,parametros.tipobase);
    %mostra_base(base)
    
    profile on
    PRbase = 1:np; %use todo o p
    [A,M] = obtem_base_discreta(parametros,p,malha,base,...
        parametros.tensorial,KP,NP,np_comp,PRbase);
    
    profile viewer
    if plota.base
        plota_base(parametros,malha,NP,p,A,base,pasta_raio,...
            plota,estagio);
    end
  
    %o problema eh aproximar o vetor f por uma combinacao linear das
    %colunas da matriz A
    grava_tex = true;
    [b,alpha,s,e,map,condM] = aproximacao(parametros,NP,...
        p,np_comp,CD,LD,base,A,f,M,pasta_raio_metodo,plota,estagio,grava_tex);
    erro_L2 = norma_erro_L2(map,np_comp);
    
    fprintf(arq,'\\newcommand{\\PARMerroHilb}{%s}\n',...
        converte_raio_tex(erro_L2));
    erro_Linf = norma_erro_Linf(map);
    fprintf(arq,'\\newcommand{\\PARMerroLinf}{%s}\n',...
        converte_raio_tex(erro_Linf));
    fprintf(2,'norma do erro = %9.6f (L2) %9.6f (Linf)\n', erro_L2, erro_Linf);
    fprintf(2,'condM %9e\n',condM);
    fprintf(arq,'\\newcommand{\\PARMcond}{%s}\n',...
        converte_raio_tex(condM));
    
    if parametros.funcao == 0
        fprintf(2,'calculando tau\n');
        E = (e'*e)/np;
        E = sparse(E);
        [evec_E, eval_E] = eigs(E,1);
        tau = sqrt(max(abs(eval_E)));
        fprintf(2,'tau = %9.6f\n',tau);
        fprintf(arq,'\\newcommand{\\PARMtau}{%s}\n',...
            converte_raio_tex(tau));
        %calculando a funcao de pior caso
        alpha_pior = evec_E(:,1);
        fprintf(2,'norma do autovetor = %9.6f\n', norm(alpha_pior,2));
        f_pior = (f*alpha_pior);
        figure(15 + plota.janela_base);
        plota_funcao(p,f_pior,1,CD,LD,NP,NaN,NaN);
%        title(sprintf('pior funcao %d',j),'FontSize',20);
        hold off
        if plota.salva_eps
            saveas(gcf,sprintf('%s/fpior.eps',pasta_raiz));
        end
        
    end
    
    condM_graf(ir,1) = condM;
    erro_graf(ir,1) = erro_L2;
    fclose(arq);
    
    if parametros.funcao == 0
        plota_espectro(parametros,f,e,np_comp,freq,pasta_raio_metodo,...
            plota,estagio,grava_tex);
        if plota.mapa_erro
            figure(7+plota.janela_base);
            if plota.mapa_erro_curva_nivel
                plot_contour_funcao(parametros,p,map,CD,LD,NP);
            else
                emax = max([plota.emax, max(abs(map))]);
                plota_mapa_de_erro_uniforme(p,map,CD,LD,NP,KP,0,emax);
            end
            title(sprintf('mapa de erro %s',...
                estagio),'FontSize',20);
            hold off
            if plota.salva_eps
                saveas(gcf,sprintf('%s/mapa_erro.eps',pasta_raio));
            end
        end
    end
end
profile on
figure(3); clf;
semilogy(raio_graf,erro_graf);
hold on
semilogy(raio_graf,erro_graf,'or')
title('erro em funcao do raio','FontSize',20)
set(gca,'Fontsize', 20)
aa = min(erro_graf);
bb = max(erro_graf);
ylim([aa - aa/2, bb + bb/2])
if plota.salva_eps
    saveas(gcf,sprintf('%s/erro_x_raio.eps',pasta_tipobase_metodo));
end
profile viewer

profile on
figure(4); clf;
semilogy(raio_graf,condM_graf);
hold on
semilogy(raio_graf,condM_graf,'or')
title('condM em funcao do raio','FontSize',20)
set(gca,'Fontsize', 20)
ylim([10^0 10^22])
if plota.salva_eps
    saveas(gcf,sprintf('%s/condicao_x_raio.eps',pasta_tipobase_metodo));
end
profile viewer

% figure(5); clf;
% semilogy(raio_graf,somavM_graf);
% hold on
% semilogy(raio_graf,somavM_graf,'or')
% title('soma autovalores em funcao do raio','FontSize',20)
% set(gca,'Fontsize', 20)
% ylim([10^0 10^22])
% if plota.salva_eps
%     saveas(gcf,sprintf('%s/soma_autovalores_x_raio.eps',pasta_tipobase_metodo));
end
