function principal_plota_1D_psi(ifig,tipok,lista_T,lista_raio)
clc
close all
%pasta principal para os plotes
pasta_raiz = '~/Desktop/dout2012/Texto/Comum/E4tempplots';
cor = 'b';
n = 1000;
sub_pasta = cria_pasta(sprintf('%s/t%02d/elem',...
    pasta_raiz,tipok));
arquivo = sprintf('maee.eps');

%plota funcao-mae
ifig = ifig + 1;
titulo = sprintf('t%02d mae', tipok);
fprintf(2,'%s\n', titulo);
scrsz = get(0,'ScreenSize');
figure(ifig);
set(ifig,'Position',[1 scrsz(4)/3 scrsz(3)/2 scrsz(4)/3]);
clf
hold on
L = 16; 
y_int = plota_psi_funcao_mae_intervalo_y(tipok);
plota_1D_funcao_mae(tipok,L,n,cor);
xlim([-6.1 6.1])
ylim(y_int);
%title(titulo,'FontSize',20)

saveas(gcf,sprintf('%s/%s',sub_pasta,arquivo), 'psc2');
hold off
for T = lista_T
    for R = lista_raio
        %plota funcao mae periodica
        titulo = sprintf('t%02d T = %d R = %8.6f', tipok,T,R);
        arquivo = sprintf('R%09d-T%d.eps',floor(1000000*R+0.5),T);
        fprintf(2,'%s\n', titulo);
        icor = 0;
        ifig = ifig + 1;
        figure(ifig); clf
        hold on
        M = psi_num_termos(tipok,T/R);
        assert(M < Inf)
        plota_1D_psi(tipok,R,T,n,cor);
        %title(titulo,'FontSize',20)
        saveas(gcf,sprintf('%s/%s',sub_pasta,arquivo), 'psc2');
        hold off
    end
end