clear all
clc
close all
%pasta principal para os plotes
pasta_raiz = cria_pasta('~/Desktop/dout2012/Texto/Comum/Eapagar');
%lista_tipok = [0:6, 9];
lista_tipok = 12;
LD = [20, 20];  %tamanho do dominio
NC = LD;   %tamanho da grade de centos
CD = 0.5*LD;  %centro do dominio
C = [20/12 20/2];% CD;       %centro do elemento
nfig = 0;

for tipok = lista_tipok
    lista_dobrado = true;
    for dobrado = lista_dobrado
        for tensorial = true;%[false, true]
            lista_raio = 1; %raios relativos
            for raio_rel = lista_raio
                R = 2*raio_rel*(LD./NC); %raio absoluto
                %R = [5 5] .* (LD./NC); %raio absoluto
                if dobrado
                    MX = psi_num_termos(tipok,LD(1)/R(1));
                    MY = psi_num_termos(tipok,LD(2)/R(2));
                else
                    MX = 0;
                    MY = 0;
                end
                if MX < Inf && MY < Inf
                    titulo = sprintf('t%02d %d %d %8.6f %8.6f', tipok,...
                        dobrado,tensorial,raio_rel,raio_rel);
                    sub_pasta = cria_pasta(sprintf('%s/t%02d/elem',...
                        pasta_raiz,tipok));
                    arquivo = ...
                        sprintf('dob%d-ten%d-RX%09.6f-RY%09.6f.eps',...
                        dobrado,tensorial,raio_rel,raio_rel);
                    fprintf(2,'%s\n', titulo);
                    nfig = nfig + 1;
                    figure(nfig)
                    plota_2D_phi(tipok,tensorial,...
                        C,R,CD,NC,LD);
                    %title(titulo)
                    saveas(gcf,sprintf('%s/%s',sub_pasta,arquivo));
                end
            end
        end
    end
end