function v = psi_mae(z,tipok,L_rel)
%calcula funcao mae unidimensional (raio absoluto 1)
%no argumento z. Se dobrado eh true 
%supoe dominio toroidal com periodo L_rel e calcula por somatoria de copias
%se dobrado eh false supoe dominio nao toroidal. 
%Note que (L_rel eh o tamanho absoluto do dominio divido pelo 
%raio absoluto.

%if dobrado
    while (z < -L_rel/2)
        z = z + L_rel;
    end
    while (z > L_rel/2)
        z = z - L_rel;
    end
    m = psi_num_termos(tipok,L_rel);
    assert(m < 100, 'este tipo de funcao nao pode ser dobrado')
% else
%     m = 0;
% end
v = 0;
for i = -m:m
    zi = z + i*L_rel;
    vi = funcao_mae(zi,tipok);
    if (z == 6.937500) || (z == 0.687500)
        fprintf(2,'z = %9.6f  zi = %9.6f  vi = %9.6f \n',z, zi,vi);
    end
    v = v + vi;
end

assert(funcao_mae(z+(m+1)*L_rel,tipok) == 0)
assert(funcao_mae(z-(m+1)*L_rel,tipok) == 0)