clear all 
clc
close all

pasta = cria_pasta(sprintf('~/Desktop/dout2012/Texto/Comum/E4cap6'));

%pontos de amostragem
x = [-1 -.8 -.75 -.6 -.5 -.45 -.3 0 .1 .2 .4 .5 .55 .7 .9 1];
n = length(x);
%pontos para o tracado das curvas
x_ini = min(x);
x_fim = max(x);
x_passo = (x_fim-x_ini)/1000;
xp = x_ini-20*x_passo:x_passo:x_fim+20*x_passo;
np = size(xp,2);

%dados reais
f = zeros(1,n);
for i = 1:n
    f(i) = 1 - x(i)^2;
end
for i = 1:np
    fp(i) = 1 - xp(i)^2;
end
figure(1)
[Ae,Be,Ce,sxe] = ajusta_parabola(x,f,xp,fp,pasta,'exato'); 

%dados de medida
tol = 0.05;
g = f + tol*randn(1,n);
figure(2)
[A0,B0,C0,sx0] = ajusta_parabola(x,g,xp,fp,pasta,'normal'); 

%inserindo dado anomalo
k = floor(n*0.75);
g(k) = g(k) + 2;
figure(3)
[A1,B1,C1,sx1] = ajusta_parabola(x,g,xp,fp,pasta,'anomalo');

niter = 4;
sxi = sx1;
for iter = 1:niter
    sigma = ((niter + 1 - iter)^2)*tol;
    fprintf(2,'sigma = %9.6f\n', sigma);
    for i = 1:n
        zf = g(i) - sxi(i);
        zg = zf/hypot(1,zf/sigma);
        h(i) = sxi(i) + zg;
        fprintf(2,'  erro = %9.6f eh reduzido para %9.6f\n',zf,zg);
    end
    figure(3+iter)
    rot = sprintf('cor%02d',iter);
    [A2,B2,C2,sx2] = ajusta_parabola(x,h,xp,fp,pasta,rot);
    sxi = sx2;
end