function w = recalcula_peso_WQ(f,s,alpha,sigma)
%calcula o peso de cada ponto que eh a probabilidade de que ele nao seja
%outlier. Supoe que o  valor de f no ponto i, se nao eh outlier, tem 
%distribuicao gaussiana
%com media s(i) e desvio padrao sigma. E que a probabilidade a priori de ser
%um outlier eh alpha.
np = size(f,1);
nf = size(f,2);
assert(size(s,1) == np)
assert(size(s,2) == nf)
w_max = 0;
w = zeros(np,1);
for i = 1:np
    soma2 = 0;
    for j = 1:nf
        zf = f(i,j) - s(i,j);
        soma2 = soma2 + zf^2;
    end
    z2 = soma2/nf;
    if z2 > 10*sigma^2
        w(i,1) = 0;
    else
        gp = exp(-z2/(sigma^2)/2)/(sigma*sqrt(2*pi));
        w(i,1) = (1 - alpha)*gp/(alpha + (1 - alpha)*gp);
        if w(i,1) > w_max
            w_max = w(i,1);
        end
    end
end
%normaliza de modo que o maior peso seja 1
if w_max == 0
    w = ones(np,1);
else
    w = w/w_max;
end
assert(size(w,1) == np)
assert(size(w,2) == 1)