function malha_r = refina_malha(malha_g,KF,p)
%dada a malha {malha_g} de um nivel da hierarquia, possivelmente incompleta
%constroi uma malha {malha_r} do nivel seguinte cujas celulas sao todas as
%filhas da celula de {malha_g}. Supoe que cada celula de {malha_g} tem 
%KF(1) x KF(2) filhos na malha nova. Tambem divide o vetor ixgpontos de cada
%celula supondo que ele se refere ao vetor de pontos p. Na nova malha 
%cada vetor ixgpontos vai se referi ao vetor p.

malha_r.NC = malha_g.NC .* KF;
malha_r.CD = malha_g.CD;
malha_r.LD = malha_g.LD;
LD_f = malha_r.LD ./ malha_r.NC; %tamanho das celulas refinadas
mc_g = nnz(malha_g.ixc);
mc_r = 0;
ixc_r = sparse(malha_r.NC(1),malha_r.NC(2));

for i = 1:mc_g
    celi = malha_g.celulas(i);
    %cria as celulas filhas
    jf = mc_r + 1;  %indice da primeira celula filha na malha nova
    for ix = 0:KF(1)-1
        for iy = 0:KF(2)-1
            posf = (celi.pos .* KF) + [ix, iy];
            mc_r = mc_r + 1;
            malha_r.celulas(mc_r) = constroi_celula(posf,malha_r.NC); 
            ixc_r(posf(1)+1,posf(2)+1) = mc_r;
        end
    end
    %distribue os pontos de celi pelos filhos
    Di = retangulo_da_celula(celi.pos,malha_g.CD,malha_g.NC,malha_g.LD);
    cantoi = (Di(:,1))';
    %fprintf(2,'distribuindo pontos da celula %d\n',i);
   
    for k = celi.ixgpontos
        pk = p(k,:);
        assert((pk(1) > Di(1,1)) && (pk(1) < Di(1,2)))
        assert((pk(2) > Di(2,1)) && (pk(2) < Di(2,2)))
        %determina posicao da celula filha dentro da grade de filhas de celi
        dk = floor((pk - cantoi) ./ LD_f);
        jk = jf + dk(1)*KF(2) + dk(2);
        celf = malha_r.celulas(jk);
        npf = size(celf.ixgpontos,2);
        celf.ixgpontos(npf+1) = k;
        malha_r.celulas(jk) = celf;
    end
end
malha_r.ixc = ixc_r;
assert(mc_r == mc_g*prod(KF))
        
    
            

