function A = replica_coluna_da_matriz_A(A0,NC,base,NP,PRbase)
%dada a coluna padrao A0 da matriz A preenche a matriz A para a base dada.
%O vetor PRbase diz quais pontos da grade completa de amostragem sao usados
%pela malha.

np_comp = size(A0,1);
fprintf(2,'numero de pontos na grade completa = %d\n',np_comp);
assert(size(A0,2) == 1)
np_redu = size(PRbase,2);
assert(np_redu > 0)
assert(max(PRbase) <= np_comp)
assert(min(PRbase) >= 1)
%calcula vetor RPbase tal que RPbase(i) eh o indice na grade de amonstragem
%reduzida do ponto p(i) da grade completa; ou zero se p(i) nao estah na
%base reduzida
RPbase = inverte_permutacao(PRbase,np_comp);
nb = size(base.elementos,2);
A = sparse(np_redu,nb);
%mostra_elemento_zero(A0,NP);
for j = 1:nb
    if mod(j,10) == 1
        fprintf(2,' %d',j);
    end
    elemj = base.elementos(j);
    posj = elemj.pos;
    if j == 459
        fprintf(2,'permutando a coluna %d\n',j);
    end
    Aj_redu = permuta_coluna_da_matriz_A(A0,posj,NC,NP,RPbase,np_redu);
%     if j == 459
%         i = 3390;
%         Aij = full(Aj_redu(i,1));
%         fprintf(2,'coluna permutada, A(%d,%d) = %23.15e\n',i,j,Aij);
%     end
    assert(issparse(Aj_redu))
    A(:,j) = Aj_redu;
    %fprintf(2,' total de nao nulos = %d\n',nnz(A));
end
fprintf(2,'\n');
