function M = replica_coluna_da_matriz_M(M0,malha,base)
%dada a coluna padrao M0 da matriz M preenche a matriz M para a base dada
%supoe que o metodo eh 1 (MQ). Supoe que M0 eh a coluna correspondente ao
%elemento de posicao [0 0] de uma base completa uniforme com NC(1) x NC(2)
%celulas e que {base} eh um subconjunto dessa base completa.
nb_comp = prod(malha.NC);
nb_redu = size(base.elementos,2);
%constroi um vetor REbase tal que REbase(i) eh o
%numero na base reduzida do elemento i da base completa
REbase = sparse(1,nb_comp);
for j = 1:nb_redu
    elemi = base.elementos(j);
    posi = elemi.pos;
    i = 1 + posi(1)*malha.NC(2) + posi(2);
    REbase(i) = j;
end

ixM0 = (find(M0))';
for j = 1:nb_redu
    if mod(j,10) == 1
        fprintf(2,' %d',j);
    end
    posj = base.elementos(j).pos;
    %constroi a coluna j da base reduzida
    Mj_redu = sparse(nb_comp,1);
    for i0 = full(ixM0)
        % i0 eh o indice na base completa de um elemento que tem produto
        % escalar nao nulo com o elemento zero. Determina o indice ij do
        % elemento que tenha a mesma posicao em relacao ao elemento j que
        % i0 tem em relacao ao elemento zero.
        i0y = mod(i0-1,malha.NC(2));
        i0x = floor((i0-1 - i0y)/malha.NC(2));
        ijx = mod(i0x + posj(1),malha.NC(1));
        ijy = mod(i0y + posj(2),malha.NC(2));
        ij_comp = 1 + ijx*malha.NC(2) + ijy;
        ij_redu = REbase(ij_comp);
        if ij_redu ~= 0
            assert((ij_redu >= 1) && (ij_redu <= nb_redu))
            M(ij_redu,j) = M0(i0,1);
        end
    end
end
fprintf(2,'\n');