function D_c = retangulo_da_celula(pos,CD,NC,LD)
%devolve o retangulo da celula de posicao pos
%da grade regular definida por CD,NC,LD. O retangulo eh uma matriz [[xmin
%xmax];[ymin ymax]].

assert((pos(1) >= 0) && (pos(1) < NC(1))) 
assert((pos(2) >= 0) && (pos(2) < NC(2)))
LD_c = LD./NC; %tamanho de cada celula
ED = CD - 0.5*LD; %eh o canto inferior do dominio
ED_c = ED + pos .* LD_c; %eh o canto inferior da celula
D_c = [ED_c; ED_c + LD_c]';  
