function r = suporte_da_funcao_mae(tipok)
%devolve o raio do suporte da funcao-mae (possivelmente infinito)

if tipok == 0 %phi Multiquadrica nu = 1
    r = Inf;
elseif tipok == 1 %Spline thin-plate com nu = 1
    r = Inf;
elseif tipok == 10 %Spline thin-plate com nu = 2
    r = Inf;
elseif tipok == 11 %Spline thin-plate com nu = 3
    r = Inf;    
elseif tipok == 2 %Pulso compacto
    r = 1;
elseif tipok == 3 %Multiquadrica com nu = -1
    r = Inf;
elseif tipok == 4 %pulso (b-spline) retangular
    r = 0.5;
elseif tipok == 5 %pulso B-spline triangular
    r =1.0;
elseif tipok == 6 %pulso B-spline quadratico
    r = 1.5;
elseif tipok == 12 %pulso B-spline cubico
    r = 2;
elseif tipok == 14 %pulso B-spline quartico
    r = 2.5;
elseif tipok == 15 %pulso B-spline de grau 5
    r = 3.0;
elseif tipok == 7 %Pulso compacto
    r= 1.0;
elseif tipok == 8 %Pulso compacto
    r=1;
elseif tipok == 9 %gaussiana 
    r = 8.5;
elseif tipok == 13  %mexicana sigma = 2
    r =8.5*2;
    elseif tipok == 31  %mexicana sigma = 10
    r =8.5*10;
elseif tipok == 32  %mexicana sigma = 5
    r =8.5*5;
elseif tipok == 33  %mexicana sigma = 0.5
    r =8.5*0.5;
elseif tipok == 34  %mexicana sigma = 1
    r =8.5;
elseif tipok == 35  %mexicana sigma = 2.5
    r =8.5*2.5;
elseif tipok == 36  %mexicana sigma = 3
    r =8.5*3.0;
elseif tipok == 37  %mexicana sigma = 3.5
    r =8.5*3.5;
elseif tipok == 38  %mexicana sigma = 4
    r =8.5*4.0;
elseif tipok == 40 %funcao gabor
    r = 8.5*0.5;
elseif tipok == 41 %funcao gabor
    r = 8.5*0.75;
elseif tipok == 42 %funcao gabor
    r = 8.5*1.0;
elseif tipok == 43 %funcao gabor
    r = 8.5*1.25;
elseif tipok == 44 %funcao gabor
    r = 8.5*1.5;
elseif tipok == 45 %funcao gabor
    r = 8.5*2.0;
elseif tipok == 46 %funcao gabor
    r = 8.5*3;
elseif tipok == 47 %funcao gabor
    r = 8.5*5.0;
elseif tipok == 52 %funcao lanczos a = 2
    r = 2;
elseif tipok == 53 %funcao lanczos a = 3
    r = 3;
elseif tipok == 60 %funcao de ricker (chapeu mexicano)
    r = 9;
else
    assert(false, 'tipok = %d invalido', tipok);
end
