function teste_hier3_adap
close all
fclose('all');
clc
%--- funcao a aproximar
%Se o parametro for 0 faz analise global
parametros.funcao = 17;
%--- dimensao do dominio
parametros.dim_dominio = 2;
%--- tamanho do dominio
%o dominio D eh a caixa [0,tam_dominio]^dim_dominio
%nao precisa ser um inteiro.
parametros.tam_dominio = [8 8];
%--- centros
%
%
%
parametros.n_centros = NaN; %irrelevante
parametros.tam_grade_centros = [NaN NaN]; %definido internamente
%--- grade de integracao
%se {n_pontos = 0} usa uma grade uniforme de pontos 
%caso contrario, usa um  conjunto de
%n_pontos centros nao uniforme {p(i)}.
%ha aproximadamente pts_por_celula pontos de amostragem por celula
parametros.n_pontos = NaN;
parametros.pts_por_celula = 1; 
%--- base de aproximacao
parametros.tipobase = 6;
parametros.raio = 1.0;
parametros.raios = parametros.raio;
parametros.raio_otimo = parametros.raio;
parametros.le_matriz = false;
parametros.min_nivel = 7;
parametros.max_nivel = 17; 
parametros.n_pontos = 0;%ceil(2^(parametros.max_nivel - 2));
parametros.prebase_gorda = false; %inclue todo elem que cobre celula critica
parametros.adap_por_nivel = true; %usa reducao de base na hier_adap
parametros.hier_adap_recalc = false; %recalcula alpha depois de reduzir a base
parametros.tipoarvore = 2;  %1=diadica, 2=quadtree
parametros.tensorial = true;

%ajusta tamanho do dominio conforme o tipo de arvore 
if parametros.tipoarvore == 1
    fator = [2^0.25, 2^(-0.25)];
    parametros.tam_dominio = parametros.tam_dominio .* fator;
end

% --- metodo de aproximacao
parametros.metodo = 3; %1 MQ, 3 MQ com supressao de outliers.
%--- criterio de aproximacao adaptativa
parametros.tol = 0.002;
parametros.heu_adap = 2;

%opcoes de plotagem
plota.funcao = true;
plota.pontos = NaN;
plota.arvore = false;
plota.base = true; %desenha os elementos da base
plota.curva_nivel = false; %desenha os elementos por curvas de niveis
plota.coeficientes = false;
plota.componentes = false;
plota.base_dual = true;
plota.aproximacao = true;
plota.erro = true;
plota.emax = 1.5*parametros.tol;
plota.mapa_erro = true;
plota.erro_curva_nivel = false;
plota.mapa_erro_curva_nivel = false;
plota.salva_eps = true;

principal_avalia_hier3_adap(parametros,plota)

