function teste_uniforme
close all
fclose('all');
clc
%--- funcao a aproximar
%Se o parametro for 0 faz analise global
parametros.funcao = 0;
%--- dimensao do dominio
parametros.dim_dominio = 2;
%--- tamanho do dominio
%o dominio D eh a caixa [0,tam_dominio]^dim_dominio
%deve ser um inteiro positivo.
parametros.tam_dominio = [20 20];
%--- centros
%se {n_centros = 0} usa uma grade uniforme de centros 
%caso contrario, usa um  conjunto de
%n_centros centros nao uniforme {C(i)}.
parametros.n_centros = 0;
parametros.tam_grade_centros = parametros.tam_dominio;
%--- grade de integracao
%se {n_pontos = 0} usa uma grade uniforme de pontos 
%caso contrario, usa um  conjunto de
%n_pontos centros nao uniforme {p(i)}.
%ha aproximadamente pts_por_celula pontos de amostragem por celula
parametros.n_pontos = 0;
parametros.pts_por_celula = 9; 
%--- base de aproximacao
parametros.tipobase = 14;
parametros.raio = 1.0;
parametros.raios = parametros.raio;
parametros.raio_otimo = parametros.raio;
parametros.le_matriz = true;
parametros.min_nivel = NaN;
parametros.max_nivel = NaN;
parametros.prebase_gorda = NaN;
parametros.adap_por_nivel = NaN; %usa reducao de base na hier_adap
parametros.hier_adap_recalc = NaN; %recalcula alpha depois de reduzir a base
parametros.tipoarvore = NaN;  %1=diadica, 2=quadtree
parametros.tensorial = true;

% --- metodo de aproximacao
parametros.metodo = 1; %1 MQ, 3 MQ com supressao de outliers.
%--- criterio de aproximacao adaptativa
parametros.tol = NaN;
parametros.heu_adap = NaN;

%opcoes de plotagem
plota.funcao = true;
plota.pontos = NaN;
plota.arvore = false;
plota.base = true; %desenha os elementos da base
plota.curva_nivel = false; %desenha os elementos por curvas de niveis
plota.coeficientes = false;
plota.componentes = false;
plota.base_dual = true;
plota.aproximacao = (parametros.funcao ~= 0);
plota.erro = (parametros.funcao ~= 0);
plota.emax = NaN;
plota.mapa_erro = (parametros.funcao == 0);
plota.erro_curva_nivel = false;
plota.mapa_erro_curva_nivel = false;
plota.salva_eps = true;

principal_avalia_uniforme(parametros,plota)
